$Title Cryogenic Carbon Capture Dispatch Model
$Ontext
This model is a simplified version of Cohen's model. It utilized the same objective
gunction methodology, but does not have the ability to calculate reserve commitment.
The only scenario is CCC.
$Offtext

*For running locally/ creating GDX file. Comment to run on NEOS server
*Read input data from Excel spreadsheet
$call GDXXRW input_data_unit_comm_ccs_v3.xls  @input_data_unit_comm_ccs_v3.txt
*Store input data to GAMS .gdx file
$gdxin input_data_unit_comm_ccs_v3.gdx

*$gdxin in.gdx

Sets
   t 'time intervals'
   p 'plants'
$load t p
   pcu 'under supply penalties' /1*8/

Scalar
   scale     'objective scaling factor' /1/
   k_stg     '(kg/hr)/MW electricity required to produce 1 kg/hr of LNG'                                                     /9273.64/
   tau_rcy   'hr time constant of gas turbine which is equal to 5 min (to be used later on)'                                 /0.08/
   k_rcy     'MW/(kg/hr) gain of the first order differential equation for gas power production from natural gas (assuming 58.8% of HHV of Natural gas (47.141 KJ/gr) is converted to gas power)' /0.00763/
   tau_boiler 'hr time constant of coal power production (to be used later on)'                                               /2/
   k_boiler   'gain of the first order differential equation for coal power production (using setpoint of the coal power as the design variable)(to be used later on)' /1/
   tau_ng     'hr  time constant of the first order differential equation (it takes 5 min to take NG from pipeline and deliver it to gas turbine) (to be used later on)' /0.08/
   k_ng       'gain of the first order differential equation for gas power production  kg/hr'                                 /1/
   etha_s_coal '0.386/0.85 where 0.85 is boiler efficiency and combustion eff = 1'                                             /0.4444/
   etha_cp     'total efficiency of power production from coal thermal heat to power'                                          /0.368/
   etha_cp_gas 'efficiency of power production in GT'                                                                          /0.3275/
   etha_s_gas  'combined efficiency for power production from heat of HRSG (including boiler efficiency)'                      /0.3844/
   boiler_eff  '(NETL)'                                                                                                        /0.88/
*   deltaH_coal 'j/kg  enthalpy of combustion of coal (Wyoming) IECM'                                                          /19397000/
*deltaH_coal                         'j/kg  enthalpy of combustion of coal (Illinois #6)'                                                            /27135000/

   CEPCI_1979  'cost of index factor for year 1979'                                                                            /238.7/
   CEPCI_1998  'cost of index factor for year 1998'                                                                            /389.5/
   CEPCI_2002  'cost of index factor for year 2002 (January 2002)'                                                             /390.4/
   CEPCI_2013  'cost of index factor for year 2013 (August 2013)'                                                              /564.7/
   delta_H_steam 'kJ/kg , heat of vaporization of steam at 3 MPa from 103 C to 600 C (Sandlers textbook)'                       /3260/
   deltaH_gas  'Mj/kg  HHV, enthalpy of combustion of gas (from IECM)'                                                          /53.890000/
   ss_mixed_ref_demand   'MW'                                                                                                  /20.3671/
   ss_ng_comp_demand     'MW'                                                                                                  /18.552/
   ss_ng_flow_rate       'kg/hr'                                                                                               /360922/
*mixed_ref_flow                      '(kg/hr)/MW gross coal power'                                                                                   /480.3/
*   mixed_ref_ratio       '20.3671 / 550    mixed ref. demand per 550 MW gross coal power (Chris Russel)'                       /0.037/
*   mixed_ref_lng         '20.3671 / 360922   !mixed ref. demand to produce 1 kg/hr LNG (Chris Russel)'                        /0.00005643/
   h_601                 'kJ/kg'                                                                                               /-4505/
   h_602                 'kJ/kg'                                                                                               /5087/
   h_604                 'kJ/kg'                                                                                               /-4775/
   h_605                 'kJ/kg'                                                                                               /-4476/
   h_701                 'kJ/kg'                                                                                               /-3304/
   h_702                 'kJ/kg'                                                                                               /-3313/
   h_703                 'kJ/kg'                                                                                               /-3313/
   h_704                 '$/kg'                                                                                                /-2693/
   cc                                                                                                                          /-9/
   dd                                                                                                                          /299/
   ee                                                                                                                          /620/
   ff                                                                                                                          /-582/

   turb_cap   'MW constant gas turbine power output for capital cost calculations'                                            /620/
   coal_cap_1 'MW constant coal power output for capital cost calculations (assuming two boilers for power production)'       /900/
   coal_cap_2 'MW constant coal power output for capital cost calculations (assuming two boilers for power production)'       /900/
   no_boilers                                                                                                                 /2/
   pipe_comp_cap                                                                                                              /5/
   no_sim     'number of days for simulation'                                                                                 /8/
   lng_dens   'kg/m3'                                                                                                         /290.6/
   k1                                                                                                                         /4.8509/
   k2                                                                                                                         /-0.3973/
   k3                                                                                                                         /0.1445/
   max_demand                                                                                                                 /2000/

   max_ratio_gas_pwr                                                                                                          /0.5/
   max_ratio_gas_comb                                                                                                         /0.2/
   max_ratio_lng_ccc                                                                                                         /0.15/

* Relative Weighting in the object functions
   A                                                                                                                         /1/
   B                                                                                                                         /1/
   C                                                                                                                         /1/
   D                                                                                                                         /1/
   U                                                                                                                         /100000000000/
   O                                                                                                /10000000/



   Tstep_RT 'length of time interval in real-time market (hours)'                                                            /0.25/


   FW_period_length 'number of intervals in FW planning period'                                                              /72/
   look_ahead   'number of hours to look-ahead when performing optimization'                                                 /0/


   j                                                                                                                         /1/
   k                                                                                                                         /672/
   m                                                                                                                         /1/
   over_supdem_imbal_penalty   'penalty for over supply of energy ($/MWh)' /250/
   supdem_imbal_penalty     'penalty for supply/demand imbalance ($/MWh)'  /5000000/
   ng_imp_pen  'penalization factor for movement of ng_pl (DCOST)'                 /0.001/
   ng_expt_pen 'penalization factor for movement of ng_expt (DCOST)'               /0.006/
   cost_ng_pl     'penalization factor for ng_pl(COST)'  /0.01/
   cost_ng_expt   'penalization factor for ng_pl(COST)'  /0.1/


*Prices
*  average prices from DOE AEO2012 early release
   price_coal    'coal price ($/MMBTU)' /1.54/

   coal_price  '$/kg for CCC calcs'                        /0.01/

   price_ng      'natural gas price ($/MMBTU)' /4/

   ng_price   'equivalent natural gas price for CCC plants($/kg) from Mostafa' /0.2133/

   price_oil     'oil price for power producers ($/MMBTU)' /24.11/

   price_biomass 'biomass price ($/MMBTU) - no source' /2/

   price_co2     'CO2 price ($/tCO2)' /35/

   h_cap_coal    'Heat capacity for coal (mmbtu/kg)' /.029233/

   h_cap_ng      'Heat capacity for NG (mmbtu/kg)' /.049560/

   hr_gas        'Heat rate of NG. Will probably need to come from excel sheet (mmbtu/mwh)' /8.5/

*  Estimated avg electricity price used for CO2 capture ramping costs
   price_elec_avg 'Average electricity price ($/MWh)' /37.5/

   U_s 'storage to/from upper bound' /6e+06/
   L_s 'storage to/from lower bound' /0/
   U_ng 'storage ng_expt/ng_pl upper bound' /6e+08/
   L_ng 'storage ng_expt/ng_pl lower bound' /0/
 ;

scalar j,k,m;

*Uncomment to run model for a single time interval
*m=1;k=1;

*Uncomment to run model for all time interavls without daily loop
*m=1;k=card(ttest);


Parameters


*Base power plant parameters for import
*   For now, assuming minimum up/down time same for input & output systems at storage facilities
   plant_type_code(p)     'plant type - code number (see spreadsheet for key)'
   vom_base(p)         'variable O&M cost ($/MWh)'
   hr_base(p)          'heat rate (MMBTU/MWh)'
   co2r_base(p)        'CO2 emissions rate (tCO2/MWh)'
   x_su_cost(p)        'startup cost ($/startup)'
   x_sd_cost(p)        'shutdown cost ($/shutdown)'
   x_min(p)            'minimum output (MW)'
   x_max(p)            'maximum output (MW)'
   plant_type(p)       'power plant type - string'
   x_ramp_up(p)        'base power plant ramp up limit (MW/min)'
   x_ramp_dn(p)        'base power plant ramp down limit (MW/min)'
   x_mintime_up(p)     'base power plant ramp up limit (MW/min)'
   x_mintime_dn(p)     'base power plant ramp down limit (MW/min)'
   x_inittime_up(p)    'base power plant initial up time (hr)'
   x_inittime_dn(p)    'base power plant initial down time (hr)'
   reg_up_max(p)       'maximum regulation up procurement (MW)'
   reg_dn_max(p)       'maximum regulation down procurement (MW)'
   nsrs_max(p)         'maximum non-spinning reserve service procurement (MW)'
   rrs_max(p)          'maximum spinning reserve service procurement (MW)'
   chp_status(p)       'status as CHP generation (1=yes, 0=no)'

*Energy storage plant parameters for import THIS SECTION CHANGES WITH CCC
   xin_min(p)        'minimum input into storage (MW)'
   xin_max(p)        'maximum input into storage (MW)'
   xin_ramp_up(p)    'ramp up limit for input to storage (MW/min)'
   xin_ramp_dn(p)    'ramp down limit for input to storage (MW/min)'
   xoutin_eff(p)     'output/input round-trip efficiency'
   s_max(p)          'maximum quantity of stored energy (MWh)'
   s_0(p)            'initial quantity of stored energy (MWh)'
   s_T(p)            'final quantity of stored energy (MWh)'

*plant CO2 capture parameters for import
*  primary performance parameters
   ccs_bool(p)        'binary flag (1=has capture, 0=no capture)'
   ymin_abs(p)        'minimum absorber load before base plant turns off or maximum load after plant turns on (fractional)'
   ymin_str(p)        'minimum stripper load before base plant turns off or maximum load after base plant turns on (fractional)'
   co2_removal_max(p) 'maximum CO2 removal (fractional)'
   energy_per_co2_strcomp_base(p) 'energy per qty of CO2 stripped and compressed (MWh/tCO2)'
   energy_per_co2_abs_base(p)     'energy per qty of CO2 absorbed (MWh/tCO2)'
   lp_steam_frac(p)         'fraction of steam to LP turbine extracted for stripping CO2 from all solvent from absorber at full-load'
*  ramp rate parameters
   yramp_str_up(p)          '(load fraction/min interval) ramp rate on turning stripper load up'
   yramp_str_dn(p)        '(load fraction/min interval) ramp rate on turning stripper load down'
   yramp_abs_up(p)          '(load fraction/min interval) ramp ratevc on turning absorber load up'
   yramp_abs_dn(p)        '(load fraction/min interval) ramp rate on turning absorber load down'
*  startup cost parameters
   su_cost_abs(p)  'startup cost for the absorption (USD/startup)'
   sd_cost_abs(p)  'shutdown cost for the absorption (USD/shutdown)'
   su_cost_str(p)  'startup cost for the absorption (USD/startup)'
   sd_cost_str(p)  'shutdown cost for the absorption (USD/shutdown)'
*  Absorber minimum up/downtime parameters
   mintime_up_abs(p) 'minimum time on after startup (hours)'
   inittime_up_abs(p) 'time plant must be on after start of study (hours)'
   mintime_dn_abs(p) 'minimum time off after shutdown (hours)'
   inittime_dn_abs(p) 'time plant must be off after start of study (hours)'
*  Stripper minimum up/downtime parameters
   mintime_up_str(p) 'minimum time on after startup (hours)'
   inittime_up_str(p) 'time plant must be on after start of study (hours)'
   mintime_dn_str(p) 'minimum time off after shutdown (hours)'
   inittime_dn_str(p) 'time plant must be off after start of study (hours)'
*  Solvent storage parameters
   tank_size(p) '(m^3) size of each of the rich and lean solvent storage tanks'
   delta_ldg(p) '(kmol solvent/kmol CO2) solvent capacity in difference between rich and lean loading'
   co2_store_init(p) '(tCO2) initial quantity of CO2 stored in rich storage tank'
   co2_store_fin(p) '(tCO2) final quantity of CO2 stored in rich storage tank'
*  Other
   cost_co2_trans_store(p) '($/tCO2) cost of CO2 transport and storage'

*  Cryogenic capture parameters
   boiler_size(p)
*------------------Jeff's Work2------------------
   ccc_su(p)
   ccc_sd(p)
*------------------End of Work2------------------

*time-varying grid parameters for import
   month(t)
   day(t)
   hour(t)
   load(t)         'total electricity demand/load (MW)'
   wind_prod(t)    'wind production (MW)'
   net_load(t)     'total demand less wind production (MW)'
   net_load_FW(t)  'net load for forward market (MW)'
   net_load_unc(t) 'uncertainty in net load (MW)'
   reg_up_base(t)  'unadjusted regulation up requirement (MW)'
   reg_dn_base(t)  'unadjusted regulation down requirement (MW)'
   reg_up_adj(t)   'regulation up requirement adjusted for new wind capacity (MW)'
   reg_dn_adj(t)   'regulation down requirement adjusted for new wind capacity (MW)'

;

*import base plant parameters
$load plant_type_code vom_base hr_base co2r_base x_su_cost x_sd_cost x_min x_max x_ramp_up x_ramp_dn x_mintime_up x_mintime_dn x_inittime_up x_inittime_dn
$load reg_up_max reg_dn_max nsrs_max rrs_max chp_status
$load xin_min xin_max xin_ramp_up xin_ramp_dn xoutin_eff s_max s_0 s_T
*import CO2 capture parameters
$load ccs_bool ymin_abs ymin_str co2_removal_max energy_per_co2_strcomp_base energy_per_co2_abs_base lp_steam_frac
$load yramp_str_up yramp_str_dn yramp_abs_up yramp_abs_dn
$load su_cost_abs sd_cost_abs su_cost_str sd_cost_str
$load mintime_up_abs mintime_dn_abs mintime_up_str mintime_dn_str
$load inittime_up_abs inittime_dn_abs inittime_up_str inittime_dn_str
$load tank_size delta_ldg co2_store_init co2_store_fin cost_co2_trans_store
*import CCC parameters
$load boiler_size ccc_su ccc_sd
*import time-varying params
$load month day hour load wind_prod net_load_unc reg_up_base reg_dn_base reg_up_adj reg_dn_adj

*associate plant type string names with each facility for type-specific calculations
acronyms coal, coal_capture, ngcc, ngblr, ocgt, ngic, oil, nucl, wind, hydro_nat, biomass, intload, stor;
plant_type(p)$(plant_type_code(p) eq 111122)=coal;
plant_type(p)$(plant_type_code(p) eq 111121)=coal_capture;
plant_type(p)$(plant_type_code(p) eq 121122)=ngcc;
plant_type(p)$(plant_type_code(p) eq 121222)=ngblr;
plant_type(p)$(plant_type_code(p) eq 121322)=ocgt;
plant_type(p)$(plant_type_code(p) eq 121422)=ngic;
plant_type(p)$(plant_type_code(p) eq 131122)=oil;
plant_type(p)$(plant_type_code(p) eq 211122)=nucl;
plant_type(p)$(plant_type_code(p) eq 221122)=wind;
plant_type(p)$(plant_type_code(p) eq 231122)=hydro_nat;
plant_type(p)$(plant_type_code(p) eq 241122)=biomass;
plant_type(p)$(plant_type_code(p) eq 311122)=intload;
plant_type(p)$(plant_type_code(p) eq 411122)=stor;

*End reading from .gdx file
$gdxin
;

parameters
   under_gen_max_violation(pcu) 'under generation violation(MW)'
      /1   1
       2   5
       3   10
       4   20
       5   30
       6   40
       7   50
       8   100000/

*  If I want constant penalty price, set all of these to the same value
   under_gen_penalty_price(pcu) 'under generation price($/MWh)'
      /1   200
       2   250
       3   300
       4   400
       5   500
       6   1000
       7   2250
       8   3000/

    max_gas_turb(p)
    max_gas_combined(p)
    max_lng_ccc_demand(p)
;

    net_load(t)=load(t)-wind_prod(t);

    max_gas_turb(p)$(ccs_bool(p) eq 1) = boiler_size(p) * 0.20;
    max_gas_combined(p)$(ccs_bool(p) eq 1) = boiler_size(p) * 0.15;
    max_lng_ccc_demand(p)$(ccs_bool(p) eq 1) = max_ratio_lng_ccc * boiler_size(p);


 Positive Variables
   x(p,t) 'Power generation (MW)'



   tot_enth_change_sp(p,t)
   ng_pl_sp(p,t)                             'kg/hr    5.718 * 10^(4) natural gas taken from pipeline at 24.95 C and 5010 kPa coal_power_sp = 700 , >= 0 ! , <= 1200      !MW (set point for power produced from coal)'
   ng_expt(p,t)                              'kg/hr'
   lng_to_tank(p,t)                          'kg/hr, LNG inlet to tank'
   ng_conv(p,t)                              'kg/hr (natural gas which is converted in the turbine)  !Part of LNG from tank outlet could be circulated back to the LNG plant to keep the systems working all the time'
   m_mr(p,t)                                 'kg/hr'
   neg_dem_slack(t)      'slack variable for penalized over supply of energy (MW)'
   pos_dem_slack(t)  'segmented slack variable for penalized under supply of energy (MW)'


   ng_pl(p,t)
   ng_ccc(p,t)
   lng_from_tank(p,t)                        'kg/hr, LNG outlet from tank'
   gas_power(p,t)                            'MW power produced in the gas turbine'
   gas_combined_pwr(p,t)
   gas_combined_pwr_treated(p,t)
   byp_lng(p,t)                              'mass balance in the inlet of the tank'
   enth_fg_coal(p,t)
   coal_power(p,t)
   lng_prod(p,t)
   ng_conv_max(p,t)
   mass_fg_gas(p,t)                          'kg/hr  Assumption: one kg/hr of gas produces 42.56 kg/hr of flue gas (page 480 of NETL report(p,t))'
   enth_fg_gas(p,t)                          'MW     835.81 and 248.81 are from NETL report (page 480)'
   mass_fg_gas_treated(p,t)                  'kg/hr  Assumption: one kg/hr of gas produces 42.56 kg/hr of flue gas (page 480 of NETL report)'
   enth_fg_gas_treated(p,t)                  'MW     835.81 and 248.81 are from NETL report (page 480)'
   normal_lng(p,t)
   mass_fg_coal(p,t)                         'kg/hr  624.86 and 66.92 are from Marks data for coal flue gas; 4.1868 is to convert cal/gr to kj/kg abd 2.778E-7 is to convert kJ/hr to MW'
   mass_coal(p,t)                            'kg/hr  Assumption one kg/hr of coal produces 10.92 kg/hr of flue gas (page 351 of NETL report)'
   mixed_ref_demand(p,t)                     'MW'
   pipe_comp_demand(p,t)                     'MW'
   power_tot(t)                            'MW'
   demand_tot_ccc(p,t)                           'MW I am not sure whether we have to include the lng_plant_demand in the demand_tot or not'
   ng_comp_demand(p,t)
   lng_demand(p,t)
   ccc_demand(p,t)
   lng_ccc_demand(p,t)
   co2_coal_prod(p,t)
   co2_ng_prod(p,t)
   co2_tot_prod(p,t)
   co2_tot_captured(p,t)
   co2_tot_emitted(p,t)
 ;
*==================================================================*
   tot_enth_change_sp.lo(p,t) = 800 ;
   tot_enth_change_sp.up(p,t) = 1800 ;
   tot_enth_change_sp.l(p,'1') = 870 ;

* Initializing with values found from running scenario 1
   x.l('nuclear','1')        = 1300  ;
   x.l('natural hydro','1')  = 200   ;
   x.l('coal 1','1')         = 6705  ;
   x.l('load','1')           = 0     ;
   x.l('coal 3 ccs','1')     = 1050  ;
   x.l('coal 4 ccs','1')     = 1050  ;
   x.l('ngcc 1','1')         = 12500 ;
   x.l('ngcc 2','1')         = 3125  ;
   x.l('ocgt 1','1')         = 0     ;
   x.l('CAES 1','1')         = 0     ;

  x.fx(p,t)$(plant_type(p) eq intload)=0;
  x.fx(p,t)$(plant_type(p) eq stor)=0;

  binary variables
   u_to_tank(p,t)
   u_from_tank(p,t)

   u_pl(p,t)
   u_expt(p,t)
;

*==================================================================*
  Variables
   tot_enth_change(p,t)
   lng_stored(p,t)
   m_mr_dummy(p,t)
   ground(t)                               'mismatch between total power production and total demand'
   aa(p,t)
   bb(p,t)
   lng_exs(p,t)
   q_ls_tot(p,t)
   q_ls_ng(p,t)
   q_ls_mr(p,t)
   q_gn_ng(p,t)
   q_gn_mr(p,t)
   q_gn_tot(p,t)
   tot_oper_cost(p,t)

   lng_to_tank_int(p,t)
   lng_from_tank_int(p,t)
   ng_pl_int(p,t)
   ng_expt_int(p,t)
*   actual_profit(p,t)
   overall_objective
   overall_Penalty
   overall_co2 ;
*-------------------------------------------------------------

   lng_stored.up(p,t)$(ccs_bool(p) eq 1) = 35000                 ;
   lng_stored.lo(p,t)$(ccs_bool(p) eq 1) = 2000                    ;
   lng_stored.l(p,t)$(ccs_bool(p) eq 1)  = 2000      ;
   ng_pl.l(p,t)$(ccs_bool(p) eq 1) = 0 ;
   lng_from_tank.l(p,'1')$(ccs_bool(p) eq 1) = 0;
   ng_expt.up(p,t) = U_ng ;
   ng_expt.lo(p,t) = 0 ;
   lng_to_tank_int.lo(p,t) = 0;
   lng_to_tank_int.up(p,t) = U_s;
   ng_expt.fx(p,t)$(ccs_bool(p) eq 0)=0;
   ng_pl.fx(p,t)$(ccs_bool(p) eq 0)=0;
   demand_tot_ccc.fx(p,t)$(ccs_bool(p) eq 0)=0;
*-------------------------------------------------------------

;

Equations

   tot_enth_change_dif_c(p,t)
   ng_conv_max_c(p,t)
   mass_fg_gas_c(p,t)                     'kg/hr  Assumption: one kg/hr of gas produces 42.56 kg/hr of flue gas (page 480 of NETL report)'
   enth_fg_gas_c(p,t)                     'MW  835.81 and 248.81 are from NETL report (page 480)'
   mass_fg_gas_treated_c(p,t)             'kg/hr  Assumption: one kg/hr of gas produces 42.56 kg/hr of flue gas (page 480 of NETL report)'
   enth_fg_gas_treated_c(p,t)             'MW 835.81 and 248.81 are from NETL report (page 480)'
   enth_fg_coal_c(p,t)
   mass_fg_coal_c(p,t)                    'kg/hr    624.86 and 66.92 are from Marks data for coal flue gas; 4.1868 is to convert cal/gr to kj/kg abd 2.778E-7 is to convert kJ/hr to MW'
   mass_coal_c(p,t)                       'kg/hr  Assumption: one kg/hr of coal produces 10.92 kg/hr of flue gas (page 351 of NETL report)'
   coal_power_c(p,t)
   gas_power_c(p,t)
   gas_combined_pwr_c(p,t)
   gas_combined_pwr_treated_c(p,t)
   normal_lng_c(p,t)
   ng_ccc_c(p,t)
   lng_prod_c(p,t)
   lng_from_tank_c(p,t)
   lng_stored_dif_c(p,t)
   byp_lng_c(p,t)
   m_mr_c(p,t)
   ng_comp_demand_c(p,t)
   mixed_ref_demand_c(p,t)                'MW'
   pipe_comp_demand_c(p,t)                'MW'
   lng_demand_c(p,t)
   ccc_demand_c(p,t)
   lng_ccc_demand_c(p,t)
   power_tot_c(p,t)                       'MW'
   demand_tot_c(p,t)                      'MW I am not sure whether we have to include the lng_plant_demand in the demand_tot or not'
   co2_coal_prod_c(p,t)
   co2_ng_prod_c(p,t)
   co2_tot_prod_c(p,t)
   co2_tot_captured_c(p,t)
   co2_tot_emitted_c(p,t)
   lng_exs_c(p,t)
   ng_pl_dif_c(p,t)
   aa_c(p,t)
   bb_c(p,t)

***********************************************Constraints**************************************************************
   lng_CCC_demand_max_c(p,t)
   gas_power_max_c(p,t)


   ng_switch(p,t)
   lng_switch(p,t)

   ramp_up_c(p,t)
   ramp_dn_c(p,t)
   min_gen_c(p,t)
   max_gen_c(p,t)

   elec_supply_demand(t)
***********************************************Constraints**************************************************************

   overall_objective_c
   overall_Penalty_c
   overall_co2_c
;

mass_coal.fx(p,t)$(ccs_bool(p) eq 0) = 0     ;
lng_ccc_demand.fx(p,t)$(ccs_bool(p) eq 0) = 0 ;
*Ramp and min/mx constraints
     ramp_up_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t)).. x(p,t)-x(p,t-1) =l= tstep_RT*x_ramp_up(p)*60  ;
     ramp_dn_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t)).. x(p,t-1)-x(p,t) =l= tstep_RT*x_ramp_dn(p)*60   ;
     min_gen_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t)).. x(p,t) =g= x_min(p);
     max_gen_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t)).. x(p,t) =l= x_max(p);



    tot_enth_change_dif_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1) .. tot_enth_change(p,t) =e= (k_boiler* tot_enth_change_sp(p,t)+(tau_boiler/Tstep_RT)* tot_enth_change(p,t-1))/( tau_boiler/Tstep_RT+1);


   ng_conv_max_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1) ..   ng_conv_max(p,t) =e= max_gas_combined(p) /max_gas_turb(p)* ng_conv(p,t);
   mass_fg_gas_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1) ..   mass_fg_gas(p,t) =e= ng_conv_max(p,t) * 42.5638;
   enth_fg_gas_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1) ..   enth_fg_gas(p,t) =e= mass_fg_gas(p,t)* etha_s_gas *(835.81-248.81) *  0.0000002778;
   mass_fg_gas_treated_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   mass_fg_gas_treated(p,t) =e= ng_conv(p,t) * 42.5638;
   enth_fg_gas_treated_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   enth_fg_gas_treated(p,t) =e= mass_fg_gas_treated(p,t) * etha_s_gas *(835.81-248.81) *  0.0000002778;
   enth_fg_coal_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1) ..   enth_fg_coal(p,t) =e= tot_enth_change(p,t) - enth_fg_gas(p,t);
   mass_fg_coal_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   mass_fg_coal(p,t) =e= enth_fg_coal(p,t) / (boiler_eff * etha_s_coal * (624.86-66.92) * 4.1868 * 0.0000002778);
   mass_coal_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   mass_coal(p,t) =e= mass_fg_coal(p,t) / 10.9291;
   coal_power_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   coal_power(p,t) =e= enth_fg_coal(p,t);

   gas_power_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1) ..   gas_power(p,t) =e= ng_conv(p,t) * etha_cp_gas * deltaH_gas/ 3600;
   gas_combined_pwr_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1) ..   gas_combined_pwr(p,t) =e= enth_fg_gas(p,t);
   gas_combined_pwr_treated_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   gas_combined_pwr_treated(p,t) =e= enth_fg_gas_treated(p,t);
   normal_lng_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   normal_lng(p,t) =e=  656.22 * (coal_power(p,t)) + 336.40 *(gas_combined_pwr_treated(p,t));
   ng_ccc_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   ng_ccc(p,t) =e= normal_lng(p,t) - ng_conv(p,t);
   lng_prod_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   lng_prod(p,t) =e= (ng_ccc(p,t) - ng_expt(p,t)) + ng_pl(p,t);
   lng_from_tank_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   lng_from_tank(p,t) =e= normal_lng(p,t) - byp_lng(p,t);

   byp_lng_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   byp_lng(p,t) =e= lng_prod(p,t) - lng_to_tank(p,t);
   aa_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..  aa(p,t) =e= (ng_ccc(p,t) + ng_pl(p,t)-ng_expt(p,t));
   bb_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..  bb(p,t) =e= (lng_from_tank(p,t) + byp_lng(p,t));
   m_mr_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1).. m_mr(p,t) =e= -(dd*bb(p,t)+aa(p,t)*ff)/(cc+ee);
   ng_comp_demand_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   ng_comp_demand(p,t) =e=  0.0000514 *(ng_ccc(p,t));
   mixed_ref_demand_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1) ..   mixed_ref_demand(p,t) =e= 0.000077101 * m_mr(p,t);
   pipe_comp_demand_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1) ..   pipe_comp_demand(p,t) =e= 0.000009792 * (ng_expt(p,t));
   lng_demand_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   lng_demand(p,t) =e= ng_comp_demand(p,t) + mixed_ref_demand(p,t);
   ccc_demand_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   ccc_demand(p,t) =e= 0.083 * coal_power(p,t) + 0.058 * gas_combined_pwr_treated(p,t);
   lng_ccc_demand_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   lng_ccc_demand(p,t) =e= lng_demand(p,t) + ccc_demand(p,t) + pipe_comp_demand(p,t);



   power_tot_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1) ..   x(p,t) =e= coal_power(p,t) + gas_power(p,t) + gas_combined_pwr(p,t);
   demand_tot_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1) ..  demand_tot_ccc(p,t) =e= lng_demand(p,t) + pipe_comp_demand(p,t) + ccc_demand(p,t);



   co2_coal_prod_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   co2_coal_prod(p,t) =e= 851.23 * coal_power(p,t);
   co2_ng_prod_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   co2_ng_prod(p,t) =e= 545.47 * gas_power(p,t);
   co2_tot_prod_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   co2_tot_prod(p,t) =e= co2_coal_prod(p,t) + co2_ng_prod(p,t);
   co2_tot_captured_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   co2_tot_captured(p,t) =e= 0.9 * co2_tot_prod(p,t);
   co2_tot_emitted_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   co2_tot_emitted(p,t) =e= 0.1 * co2_tot_prod(p,t);

   lng_exs_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   lng_exs(p,t) =e= lng_prod(p,t) - normal_lng(p,t);


***********************************************Constraints**************************************************************
  gas_power_max_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1).. gas_power(p,t) =l= max_gas_turb(p);
  lng_CCC_demand_max_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   lng_demand(p,t) + ccc_demand(p,t) =l= max_lng_ccc_demand(p);

***switch Eqs linearized with method from http://orinanobworld.blogspot.de/2010/10/binary-variables-and-quadratic-terms.html

  lng_stored_dif_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   lng_stored(p,t) =e= Tstep_RT * (lng_to_tank(p,t) - lng_from_tank(p,t)) + lng_stored(p,t-1);
  ng_pl_dif_c(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1).. ng_pl(p,t) =e= (k_ng* ng_pl_sp(p,t)+ (tau_ng/ Tstep_RT)* ng_pl(p,t-1))/( tau_ng/ Tstep_RT+1);

  ng_switch(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   ng_pl(p,t) * ng_expt(p,t) =e= 0;
  lng_switch(p,t)$(ord(t) gt 1 and ord(t)<=card(t) and ccs_bool(p) eq 1)..   lng_to_tank(p,t) * lng_from_tank(p,t) =e= 0;


   elec_supply_demand(t)$(ord(t) gt 1 and ord(t)<=card(t)).. sum(p,(x(p,t))-demand_tot_ccc(p,t)) + pos_dem_slack(t)-neg_dem_slack(t) =e= net_load(t);



   overall_objective_c..   overall_objective =e= sum((p,t)$(ord(t) gt 1 and ord(t)<=card(t)),
*                                  Operating costs of coal-fired facilities with CO2 capture

                                       ((coal_price*mass_coal(p,t)
                                            + vom_base(p)*x(p,t)
                                            + scale*price_elec_avg * (lng_ccc_demand(p,t)) + scale*ng_price * (ng_pl(p,t)-ng_expt(p,t))
                                           + scale*price_co2*co2_tot_emitted(p,t)
                                         )*Tstep_RT
                                      )$(plant_type(p) eq coal_capture)+

                                      (  (  scale*price_coal*hr_base(p)*x(p,t)
                                            + scale*vom_base(p)*x(p,t)
                                            + scale*price_co2*co2r_base(p)*x(p,t)
                                         )*Tstep_RT
                                      )$(plant_type(p) eq coal)
*or plant_type(p) eq coal_capture)
*                                  Operating cost of natural gas-fired facilities (NGCC, NGBLR, OCGT, NGIC)
                                   +  (  (  scale*price_ng*hr_base(p)*x(p,t)
                                            + scale*vom_base(p)*x(p,t)
                                            + scale*price_co2*co2r_base(p)*x(p,t)
                                         )*Tstep_RT
                                      )$(plant_type(p) eq ngcc or plant_type(p) eq ngblr or plant_type(p) eq ocgt or plant_type(p) eq ngic)
*                                  Operating costs of oil-fired facilities
                                   +  (  (  scale*price_oil*hr_base(p)*x(p,t)
                                            + scale*vom_base(p)*x(p,t)
                                            + scale*price_co2*co2r_base(p)*x(p,t)
                                         )*Tstep_RT
                                      )$(plant_type(p) eq oil)
*                                  Operating costs of nuclear facilities
                                   +  (  (  scale*vom_base(p)*x(p,t)
                                         )*Tstep_RT
                                      )$(plant_type(p) eq nucl)
*                                  Operating costs of natural flow hydro facilities
                                   +  (  (  scale*vom_base(p)*x(p,t)
                                         )*Tstep_RT
                                      )$(plant_type(p) eq hydro_nat)
*                                  Operating costs of biomass-fired facilities (keep CO2 emissions cost, but set emissions rate to 0 for now)
                                   +  (  (  scale*price_biomass*hr_base(p)*x(p,t)
                                            + scale*vom_base(p)*x(p,t)
                                            + scale*price_co2*co2r_base(p)*x(p,t)
                                         )*Tstep_RT
                                      )$(plant_type(p) eq biomass)
                             )
*                            Penalty for supply/demand imbalance
                             + sum(t$(ord(t) gt m-1 and ord(t) lt k+1),scale*neg_dem_slack(t)*supdem_imbal_penalty*Tstep_RT)
                             + sum((t,pcu)$(ord(t) gt m-1 and ord(t) lt k+1),scale*pos_dem_slack(t)*supdem_imbal_penalty*Tstep_RT)
*                            + (sum((p,t), x(p,t)-net_load(t)))*(sum((p,t), x(p,t)-net_load(t)))*1000
                             ;


overall_Penalty_c..   overall_penalty =e= sum(t$(ord(t) gt m-1 and ord(t) lt k+1),neg_dem_slack(t)*supdem_imbal_penalty*Tstep_RT)
                             + sum((t,pcu)$(ord(t) gt m-1 and ord(t) lt k+1),pos_dem_slack(t)*supdem_imbal_penalty*Tstep_RT)      ;


overall_co2_c.. overall_co2 =e= sum((p,t)$(ord(t) gt 1 and ord(t)<=card(t)),price_co2*co2r_base(p)*x(p,t)+price_co2*co2_tot_emitted(p,t));



Model CCC_one_unit /all/ ;

option optcr=0.1    ;

CCC_one_unit.OptFile = 0 ;
option limrow = 0;
option limcol = 0;
option solprint = off;

*$offlisting
$offsymxref
CCC_one_unit.scaleopt = 1 ;
option sysOut =on;
*option nlp=knitro
option iterlim = 9000;
option reslim = 10000;

*option Savepoint=1
Solve CCC_one_unit minimize overall_objective using nlp;

CCC_one_unit.OptFile = 0 ;
option limrow = 0;
option limcol = 0;
option solprint = off;


*$offlisting
*$offsymxref
CCC_one_unit.scaleopt = 1 ;
option sysOut =on;
*option nlp=knitro
option iterlim = 9000;
option reslim = 10000;


*execute_loadpoint 'CCC_one_unit_p.gdx';
Solve CCC_one_unit minimize overall_objective using nlp
*$gdxout out.gdx


$ontext
display CCC_one_unit.modelStat
display CCC_one_unit.numInfes
display CCC_one_unit.numNOpt
display CCC_one_unit.objval
display CCC_one_unit.procUsed
display CCC_one_unit.solveStat
display CCC_one_unit.sumInfes
*display power_tot.l
*display demand_tot.l
*display tot_oper_cost.l
*display ground.l
*display overall_objective.l
*display actual_profit.l
*display m_mr.l
*display m_mr_dummy.l
*display neg_dem_slack.l
*display pos_dem_slack.l
*display ng_pl.l
*display ng_expt.l
*display ng_conv.l
*display lng_to_tank.l
*display ng_conv.l
*display coal_power.l
*display gas_power.l
*display wind_data
*display gas_combined_pwr.l
*display mixed_ref_demand.l
*display max_gas_combined
*display max_lng_ccc_demand.l
*display tot_enth_change.l
*display tot_enth_change_sp.l
*display mass_fg_gas_treated.l
*display enth_fg_gas_treated.l
*display gas_combined_pwr_treated.l
*display normal_lng.l
*display ng_ccc.l
*display lng_prod.l
*display lng_from_tank.l
*display lng_stored.l
*display byp_lng.l
*display aa.l
*display bb.l
*display m_mr.l
*display ng_comp_demand.l
*display lng_demand.l
*display ccc_demand.l
*display lng_ccc_demand.l
*display pipe_comp_demand.l
*display ng_pl_sp.l
*display lng_exs.l
$offtext

