clear
%% Nuclear parameters
beta = 0.0070; % Gabor
phi0 = 9.04e+12; % cm-2s-1 Gabor
sigmaX = 2.805e-18; % cm2 Gabor
alpha_f = -1.98e-5/beta;
alpha_m = -28.2e-5/beta;

% Fuel parameters
rho_f = 10.98*1000; %kg/m^3 for UO2 Chapter 9 thermal performance 
r_pellet = 0.4751e-2; % m NuScale Fuel Cycle
height = 2; % m NuScale Fuel Cycle
n_rod = 264*37; % total number of fuel rods in a NuScale power plant NuScale Fuel Cycle
Mf = 37*249.239935; % kg https://www.nrc.gov/docs/ML2003/ML20036D438.pdf
hg = 5678; % W/(m2*C)
h_g = 2*pi*r_pellet*hg*height;

% Moderator parameters
kappa_m = 0.545; % W/m*K thermal conductivity for water at 300 C
rho_m = 750.28; % kg/m3 https://www.engineeringtoolbox.com/water-density-specific-weight-d_595.html
mu_m = 0.0000859; % N*s/m2 dynamic viscosity of saturated water at 300C
Pr_m = 0.89; % for moderator at 300 C Pr = mu*Cp/kappa
r_reactor = 1.505; % m NuScale Fuel Cycle
V = 2*pi*r_reactor^2; % m3
Mm = rho_m*V; % kg

% Calculation of convective heat transfer coefficient h
p = 1.259e-2; % NuScale Fuel Cycle
Dh = 2*r_pellet*(4/pi*(p/(2*r_pellet))^2 - 1); %https://www.nuclear-power.net/nuclear-engineering/fluid-dynamics/internal-flow/hydraulic-diameter-2/
vel = 0.93; %m/s Design of a Small Modular Nuclear Reactor
Re = rho_m*vel*Dh/mu_m; %Reynolds number
Nu = 0.023*Re^0.8*Pr_m^0.4; %Dittus-Boelter correlation Nu = 0.023Re^0.8Pr^0.4 Chapter 9
h = Nu*kappa_m/Dh; % W/m2*K

% Calculations of A1 and A3
As = n_rod*(height*2*pi*r_pellet + 2*pi*r_pellet^2); % contact surface area
r_clad = 0.0609e-2; % m NuScale Fuel Cycle
kappa_clad = 17; % W/mK https://publications.jrc.ec.europa.eu/repository/bitstream/JRC100644/lcna28366enn.pdf

p0 = -0.0065; %0.0401; % $ Gabor
p1 = -0.440; % $/m Gabor
p2 = -0.966; % $/m2 Gabor
Lambda = 2.18e-5; % s Gabor
lambdaC = 7.728e-2; % 1/s known Gabor
lambdaI = 2.849e-5; % 1/s known Gabor
lambdaX = 2.150e-5; % 1/s known Gabor

miu = 2.2*100000; %cm/s neutron speed 
N0 = 100;

Tm0 = 283.37 ; % C Moderator temperature NuScale Fuel Cycle
Tf0 = 719 ; % C fuel temperature at the core Gabor
Tin0 = 258.3 ; % C initial temperature of inlet water NuScale Fuel Cycle

YI = 6.39e-2; %Iodine yield known Gabor
YX = 2.2e-3; % Xenon yield known Gabor
X0 = 1.49e16; % initial Xenon Gabor
I0 = 2.927e16; % initial Iodine Gabor

NA = 6.0221409e23; % avogrado's number atoms/mol
Ef = 200.7*1.6022e-13; % J/fission energy released per fission
MW = 235.043; % g/mol molar mass585
sigmaN = 585e-24; % cm^2 microscopic cross section
m = Mf*1000*4/100;            % g of enriched nuclear 424000

%% Salt Cavern parameters
Cp_H2     = zeros(60,18);
Cp_H2     = readmatrix('Cp.xlsx');
k_H2      = zeros(41,31);
k_H2      = xlsread('Hydrogen thermal conductivities.xlsx');
rho_H2    = zeros(41,31);
rho_H2    = xlsread('Hydrogen density.xlsx');
mu_H2     = zeros(41,31);
mu_H2     = xlsread('Hydrogen density.xlsx');