import numpy
import scipy
import osqp


# initial temperatures
t10 = 19; t20 = 19;

# temperature constraints
tl1 = 55; tl2 = 30; th1 = 60; th2 = 35

# heat constraints
ql1 = 10; ql2 = 20; qh1 = 90; qh2 = 80

# costs
c1 = -0.1; c2 = -1.0

# violation weights
w1 = 10000; w2 = 10000

# solve QP
P = scipy.sparse.csc_matrix([
[0, 0 ,  0,  0 , 0,  0  ], 
[0, 0 ,  0,  0 , 0,  0  ],
[0, 0 , w1,  0 , 0,  0  ],
[0, 0 ,  0, w2 , 0,  0  ],
[0, 0 ,  0,  0 , w1, 0  ],
[0, 0 ,  0,  0 , 0,  w2 ] ])
print ' P ', P

q = numpy.array([c1, c2, 0, 0, 0, 0])

A = scipy.sparse.csc_matrix([
[0.5930 , 0.0967 , 1 , 0 , -1 ,  0 ],
[0.2546 , 0.2869 , 0 , 1 ,  0 , -1 ],
[ 1     ,  0     , 0 , 0 ,  0 ,  0 ],
[ 0     ,  1     , 0 , 0 ,  0 ,  0 ],
[ 0     ,  0     , 1 , 0 ,  0 ,  0 ],
[ 0     ,  0     , 0 , 1 ,  0 ,  0 ],
[ 0     ,  0     , 0 , 0 ,  1 ,  0 ],
[ 0     ,  0     , 0 , 0 ,  0 ,  1 ]  ])
print ' A ', A

xx = numpy.infty
l = numpy.array([tl1-t10,tl2-t20,ql1,ql2,0,0,0,0])
u = numpy.array([th1-t10,th2-t20,qh1,qh2,xx,xx,xx,xx])

prob = osqp.OSQP()
prob.setup(P, q, A, l, u, alpha=1.0, polish=True, verbose=True)
res = prob.solve()


print res.x

print
Q = res.x[0:2]
print Q
G = scipy.sparse.csc_matrix.toarray(A[0:2,0:2])
print G
T = numpy.matmul(G,Q) + numpy.array([t10,t20])
print T



