import pylab
import numpy
import pickle
import mylib

myfile = open('data.pkl')
data = pickle.load(myfile)
myfile.close()

a = numpy.array(data)


# extract data from array
t  = (a[:,0] - a[0,0])/60.0
t1 = a[:,1]
t2 = a[:,2]
q1 = a[:,3]
q2 = a[:,4]

t10 = t1[0]
t20 = t2[0]

# check that data has constant sample time
dt = numpy.diff(a[:,0] - a[0,0])
tsamp = dt[0]
print numpy.max(dt), numpy.min(dt)

print 'data length ', len(t), len(t)*5/60


pylab.rcParams.update(mylib.params)

pylab.figure()

pylab.subplot(211)
pylab.plot(t,t1,label='T1')
pylab.plot(t,t2,label='T2')
pylab.plot(12,19.5,'go')
pylab.plot(28,29.9,'go')
pylab.plot(28,48.9,'go')
pylab.plot(44,79.5,'go')
pylab.plot(44,45.7,'go')
pylab.plot(58,86.3,'go')
pylab.plot(58,69.9,'go')
pylab.legend(loc="upper right")

pylab.subplot(212)
pylab.plot(t,q1,label='Q1')
pylab.plot(t,q2,label='Q2')
pylab.legend(loc="upper right")
pylab.xlabel("Time (minutes)")

pylab.savefig('plotdata.pdf')

print
print 'Data'
mytime = 12
index = int(mytime * 60 / tsamp)
print ' Time = ',mytime
print '   ',t1[index], t2[index], q1[index], q2[index], index, t[index] 
mytime = 28
index = int(mytime * 60 / tsamp)
print ' Time = ',mytime
print '   ',t1[index], t2[index], q1[index], q2[index], index, t[index] 
mytime = 44
index = int(mytime * 60 / tsamp)
print ' Time = ',mytime
print '   ',t1[index], t2[index], q1[index], q2[index], index, t[index] 
mytime = 58
index = int(mytime * 60 / tsamp)
print ' Time = ',mytime
print '   ',t1[index], t2[index], q1[index], q2[index], index, t[index] 


print

mytime = 44; index = int(mytime * 60 / tsamp)
g11 = (t1[index]-t10)/100
g21 = (t2[index]-t20)/100
print 'Gains Q1 %7.4f  %7.4f '%(g11, g21 )

mytime = 28; index = int(mytime * 60 / tsamp)
g12 = (t1[index]-t10)/100
g22 = (t2[index]-t20)/100
print 'Gains Q2 %7.4f  %7.4f '%(g12, g22 )

print
print 'Predicted Temperatures'
print   (g11 + g12) * 100 + t10,   (g21 + g22) * 100 + t20


pylab.show()

