import sys
import tclab
import time
import pickle

import mylib


sample_time = 5 # seconds

#
# events (minutes, pwr1, pwr2)
#
events=[]
events += [ (1,0,0) ]
events += [ (14,0,0)   , (15,0,100) , (15,100,0) , (15,100,100)  ]
events += [ (10,20,20) , (10,70,20) , (15,20,20) , (10,20,70)    ]
events += [ (20,20,20) , (20,20,70),  (10,20,20) , (20,70,20) , (20,20,20)]
print 'Events \n',events
print

maxcount = 0  # length of experiment in samples
for i in range(len(events)):
    t,q1,q2 = events[i]
    maxcount = maxcount + t*60/sample_time


# Connect to Arduino and display messages
a = tclab.TCLab()
print



#
# first event
#
evt = 0
t,q1,q2 = events[evt]
nextevent = t*60/sample_time
a.Q1(q1)
a.Q2(q2)


# start timer that keeps constant sample time
mytimer = mylib.ControlTimer(sample_time)
t_start = float(mytimer.nexttime)

data = []
count = 0
while count < maxcount:
    try:
        if mytimer.run():
            t1,t2,q1,q2 = a.scan()                             # get values from tclab board
            t_elap = mytimer.runtime - t_start                 # seconds since start
            t_rem  = int( (maxcount-count)*sample_time/60.0 )  # time remaining in minutes

            print evt, t_elap, '(',t1,t2,q1,q2,')', t_rem

            count = count +1
            data.append([mytimer.runtime, t1,t2,q1,q2])
            if count >= nextevent and evt < len(events):
                #print count, nextevent, evt, len(events)
                evt = evt + 1
                if evt < len(events):
                    t,q1,q2 = events[evt]
                    nextevent = nextevent + t*60/sample_time

                    # dump data at each new event
                    output = open('data.pkl', 'wb')
                    pickle.dump(data, output)
                    output.close()
                    print ' --- saved  - - - next event >>> ',t,q1,q2
                    

                a.Q1(q1) # set heater 1
                a.Q2(q2) # set heater 2



    except (KeyboardInterrupt, SystemExit):
        print '\nOK - shutting down by keyboard request\n'
        break

print

# set heater OFF
a.Q1(0)
a.Q2(0)
a.close()

print
print len(data)

output = open('data.pkl', 'wb')
pickle.dump(data, output)
output.close()

