import sys
import pylab
import numpy
import pickle
import mylib

myfile = open('data.pkl')
data = pickle.load(myfile)
myfile.close()



#
# extract data into vectors
#
a = numpy.array(data)
t  = (a[:,0] - a[0,0])/60.0
t1 = a[:,1]
t2 = a[:,2]
q1 = a[:,3]
q2 = a[:,4]

# sample time
dt = a[1,0] - a[0,0]

# lenght of data
M = len(t1)  


# initial values
y10 = t1[0]
y20 = t2[0]
u10 = q1[0]
u20 = q2[0]


# input data for prediction
u1 =  q1-q1[0]
u2 =  q2-q2[0]

# data for plotting
y1 =  t1
y2 =  t2


print
print 'Data Length ',M
print 'Sample Time ',dt

#
# load model file
#
myfile = open('model.pkl')
model = pickle.load(myfile)
myfile.close()
print model.keys()
H1 = model['H1']
H2 = model['H2']
print 'H1 H2 ',H1.shape, H2.shape

N = len( model['H11'] ) -1
print 'Number of coefficients: ',N+1


# Build Regressor
U1 = u1[N:M]
U2 = u2[N:M]

for i in range(N):
    uu1 = u1[N-1-i:M-i-1]
    U1  = numpy.column_stack((U1,uu1))
    uu2 = u2[N-1-i:M-i-1]
    U2  = numpy.column_stack((U2,uu2))
U = numpy.column_stack((U1,U2))
print U1.shape, U2.shape, U.shape


#
# Prediction
#
y1p = numpy.matmul(U,H1) + y10
y2p = numpy.matmul(U,H2) + y20
tp = t[N:]                       # time vector for prediction plot



pylab.rcParams.update(mylib.params)

# text position
xp = 90; yp = 80;


pylab.figure() # prediction
label_loc = "lower right"

pylab.subplot(211)
pylab.plot(t,y1,label='Actual') 
pylab.plot(tp,y1p,label='Prediction') 
pylab.legend(loc=label_loc )
pylab.ylim([0,100])
pylab.xlim([0,200])
pylab.text(xp,yp, 'Temperature sensor #1')


pylab.subplot(212)
pylab.plot(t,y2,label='Actual') 
pylab.plot(tp,y2p,label='Prediction') 
pylab.legend(loc=label_loc )
pylab.xlabel("Time (minutes)")
pylab.ylim([0,100])
pylab.xlim([0,200])
pylab.text(xp,yp, 'Temperature sensor #2')

pylab.savefig('predict.pdf')
pylab.show()






