import sys
import time
import pylab
import numpy
import scipy
import osqp
import pickle
import mylib
import tclab


# run length
R = 600



#
# load model file
#
myfile = open('model.pkl')
model = pickle.load(myfile)
myfile.close()
h11 = model['H11']
h12 = model['H12']
h21 = model['H21']
h22 = model['H22']

# model gains
g11 = numpy.sum(h11)
g12 = numpy.sum(h12)
g21 = numpy.sum(h21)
g22 = numpy.sum(h22)
G = numpy.array([ [g11 , g12],[g21 , g22]])

N = len(h11) - 1
print 'N  ',N

P = 100
print 'P  ',P

Nc = N+P
print 'Nc ',Nc
print

# Tuning
w1 = 0.5
w2 = 0.5
m1 = 4.0
m2 = 4.0

# setpoints
t1s = 35.0
t2s = 35.0


# Control ON/OFF
control = True

# Connect to Arduino and display messages
print
a = tclab.TCLab()

# get initial values from device
t10,t20,q10,q20 = a.scan() 

print




# temperature constraints
tl1 = 30; tl2 = 30; th1 = 60; th2 = 52

# heat constraints
ql1 = 0;  ql2 =  0; qh1 = 75; qh2 = 75

# initial costs for optimization
c1 = 1.0; c2 = 1.0


# arrays for holding data
T1s  = numpy.array( ([t10]*(N) + [numpy.NaN]*R) )  # setpoint
T2s  = numpy.array( ([t20]*(N) + [numpy.NaN]*R) )  # setpoint
T1l  = numpy.array( ([tl1]*(N) + [numpy.NaN]*R) )  # setpoint
T2l  = numpy.array( ([tl2]*(N) + [numpy.NaN]*R) )  # setpoint
T1h  = numpy.array( ([th1]*(N) + [numpy.NaN]*R) )  # setpoint
T2h  = numpy.array( ([th2]*(N) + [numpy.NaN]*R) )  # setpoint
T1p  = numpy.array( ([t10]*(N) + [numpy.NaN]*R) )  # prediction
T2p  = numpy.array( ([t20]*(N) + [numpy.NaN]*R) )  # prediction
T1ps = numpy.array( ([t10]*(N) + [numpy.NaN]*R) )  # ss-prediction no control
T2ps = numpy.array( ([t20]*(N) + [numpy.NaN]*R) )  # ss-prediction no control
T1   = numpy.array( ([t10]*(N) + [numpy.NaN]*R) )  # temperature
T2   = numpy.array( ([t20]*(N) + [numpy.NaN]*R) )  # temperature
Q1   = numpy.array( ([q10]*(N) + [numpy.NaN]*R) )  # heater
Q2   = numpy.array( ([q20]*(N) + [numpy.NaN]*R) )  # heater
Q1s  = numpy.array( ([q10]*(N) + [numpy.NaN]*R) )  # heater - tgt
Q2s  = numpy.array( ([q20]*(N) + [numpy.NaN]*R) )  # heater - tgt
Q1l  = numpy.array( ([ql1]*(N) + [numpy.NaN]*R) )  # heater - low limit
Q2l  = numpy.array( ([ql2]*(N) + [numpy.NaN]*R) )  # heater - low limit
Q1h  = numpy.array( ([qh1]*(N) + [numpy.NaN]*R) )  # heater - high limit
Q2h  = numpy.array( ([qh2]*(N) + [numpy.NaN]*R) )  # heater - high limit
PE1  = numpy.array( ([0.0]*(N) + [numpy.NaN]*R) )  # prediction error
PE2  = numpy.array( ([0.0]*(N) + [numpy.NaN]*R) )  # prediction error



#
# Optimization
#


PP = scipy.sparse.csc_matrix([[0, 0], [0, 0]])
qq = numpy.array([c1, c2])
AA = scipy.sparse.csc_matrix([[g11 , g12],[g21 , g22],[1,0],[0,1]])
l = numpy.array([tl1-t10,tl2-t20,ql1,ql2])
u = numpy.array([th1-t10,th2-t20,qh1,qh2])

prob = osqp.OSQP()
prob.setup(PP, qq, AA, l, u, alpha=1.0, polish=True, verbose=False)
res = prob.solve()
Z = numpy.matmul(G,res.x)+numpy.array([[t10,t20]])
t1ss_tgt = Z[0,0]
t2ss_tgt = Z[0,1]
q1ss_tgt = res.x[0] + q10
q2ss_tgt = res.x[1] + q20
print 'T ',t1ss_tgt, t2ss_tgt, 
print 'Q ',q1ss_tgt, q2ss_tgt
print

t1s = t1ss_tgt
t2s = t2ss_tgt


# matrices for future prediction
H11p = numpy.zeros( (Nc,Nc+N) )
H12p = numpy.zeros( (Nc,Nc+N) )
H21p = numpy.zeros( (Nc,Nc+N) )
H22p = numpy.zeros( (Nc,Nc+N) )

for i in range(Nc):
    for j in range(N+1):
        H11p[i,i+j] = h11[N-j]
        H12p[i,i+j] = h12[N-j]
        H21p[i,i+j] = h21[N-j]
        H22p[i,i+j] = h22[N-j]


# matrices for control
W = numpy.eye(Nc)
W[Nc-1,Nc-1] = 100.0  # weight to get to steady state
Wc = numpy.block([[w1*W, 0*W], [0*W, w2*W]])

Q = numpy.eye(Nc)
for i in range(Nc-1):
    Q[i+1,i] = -1.0
Qc = numpy.block([[m1*Q, 0*Q], [0*Q, m2*Q]])

M = numpy.zeros((Nc,P))
for i in range(P):
    M[i,i] = 1.0
for i in range(P,Nc):
    M[i,P-1] = 1.0
Mc = numpy.block([[M, 0*M], [0*M, M]])

H11 = numpy.zeros((Nc,Nc))
H12 = numpy.zeros((Nc,Nc))
H21 = numpy.zeros((Nc,Nc))
H22 = numpy.zeros((Nc,Nc))
for i in range(Nc):
    for j in range(i+1):
        if i-j < N+1:
            H11[i,j] = h11[i-j]
            H12[i,j] = h12[i-j]
            H21[i,j] = h21[i-j]
            H22[i,j] = h22[i-j]
Hc = numpy.block([[H11, H12], [H21, H22]])

HM = numpy.matmul(Hc,Mc)
Ac = numpy.matmul(Wc,HM)
QM = numpy.matmul(Qc,Mc)
A  = numpy.vstack( (Ac, -QM) )
Ai = numpy.linalg.inv( numpy.matmul(A.T,A) )


print 'weights      ', w1, w2
print 'move penalty ', m1, m2
print 'costs        ', c1, c2
print 'setpoints    ', t1s,t2s
print 'Run length   ', R
print



print

# start timer that keeps constant sample time
count       = 0
sample_time = 5 # seconds
mytimer     = mylib.ControlTimer(sample_time)
t_start     = float(mytimer.nexttime)


while count < R:
    try:
        if mytimer.run():

            time1 = time.time()        
            # get values from device
            t1,t2,q1,q2 = a.scan() 

            
            # store values for plotting
            T1s[N+count] = t1s
            T2s[N+count] = t2s
            T1[N+count]  = t1
            T2[N+count]  = t2
            Q1[N+count]  = q1
            Q2[N+count]  = q2
            
            
            # calculate predicted temperatures at current time
            u1 = Q1[count:N+count+1]-q10
            u2 = Q2[count:N+count+1]-q20 
            a11 = numpy.dot( numpy.flip(h11) ,  u1 )
            a12 = numpy.dot( numpy.flip(h12) ,  u2 )
            a21 = numpy.dot( numpy.flip(h21) ,  u1 )
            a22 = numpy.dot( numpy.flip(h22) ,  u2 )
            t1p = t10 + a11 + a12
            t2p = t20 + a21 + a22
            
            # calculate prediction error
            pe1 = t1 - t1p
            pe2 = t2 - t2p

                        
            # store values for plotting
            T1p[N+count]  = t1p
            T2p[N+count]  = t2p            
            PE1[N+count]  = pe1
            PE2[N+count]  = pe2            
           
            
            # calculate future prediction vectors with no control 
            u1p = numpy.zeros((Nc)) + q1 - q10
            u2p = numpy.zeros((Nc)) + q2 - q20
            U1P = numpy.concatenate((u1[1:],u1p))
            U2P = numpy.concatenate((u2[1:],u2p))
            t1f = numpy.matmul(H11p,U1P) + numpy.matmul(H12p,U2P) + t10  # vector
            t2f = numpy.matmul(H21p,U1P) + numpy.matmul(H22p,U2P) + t20  # vector
            
            # steady state prediction - unbiased - no control
            t1pss = t1f[-1]
            t2pss = t2f[-1]


            # store values for plotting
            T1ps[N+count] = t1pss 
            T2ps[N+count] = t2pss

            T1l[N+count]  = tl1
            T1h[N+count]  = th1
            T2l[N+count]  = tl2
            T2h[N+count]  = th2
            Q1l[N+count]  = ql1
            Q1h[N+count]  = qh1
            Q2l[N+count]  = ql2
            Q2h[N+count]  = qh2
            

            # optimize
            t10q = t1pss + pe1
            t20q = t2pss + pe2
            l = numpy.array([tl1-t10q,tl2-t20q,ql1-q1,ql2-q2])
            u = numpy.array([th1-t10q,th2-t20q,qh1-q1,qh2-q2])
            qq = numpy.array([c1, c2])
            prob = osqp.OSQP()
            prob.setup(PP, qq, AA, l, u, alpha=1.0, polish=True, verbose=False)
            res = prob.solve()
            
                        
            # Steady State Prediction with control
            if res.info.status == 'solved':
                Z = numpy.matmul(G,res.x)+numpy.array([[t10q,t20q]])
                t1ss_tgt = Z[0,0]
                t2ss_tgt = Z[0,1]
                q1ss_tgt = res.x[0] + q1
                q2ss_tgt = res.x[1] + q2

            else:

                # save data
                qp = {}
                qp['P'] = PP
                qp['q'] = qq
                qp['A'] = AA
                qp['l'] = l
                qp['u'] = u
               
                output = open('optimize_qp.pkl', 'wb')
                pickle.dump(qp, output)
                output.close()

                #a.Q1(0.0)
                #a.Q2(0.0)
                #sys.exit()

            # set control setpoints to targets from optimizer
            t1s = t1ss_tgt
            t2s = t2ss_tgt
            
 
            # future setpoints vectors
            t1_sp = numpy.array( ( [t1s]*Nc)) - t1f  - pe1
            t2_sp = numpy.array( ( [t2s]*Nc)) - t2f  - pe2
 
            # calculate moves
            Ys = numpy.concatenate( (t1_sp,t2_sp) )
            Bc = numpy.matmul(Wc,Ys)
            B = numpy.concatenate( (Bc, 0*Bc) ) 
            
            # move plan
            Up = numpy.matmul(A.T, B)
            Up = numpy.matmul(Ai,Up)
            Up1 = Up[:P]
            Up2 = Up[P:]
            move1 = Up1[0]
            move2 = Up2[0]
            q1ss  = Up1[-1] + q1
            q2ss  = Up2[-1] + q2            


            # store values for plotting
            Q1s[N+count]  = q1ss
            Q2s[N+count]  = q2ss  



            #implement moves and limit to allowable range 
            if control:
                u1 = min( max(q1 + move1,ql1) , qh1)
                u2 = min( max(q2 + move2,ql2) , qh2)
                a.Q1(u1)
                a.Q2(u2)

            # save data
            data = [T1,T1s,T1p,T2,T2s,T2p,Q1,Q1s,Q2,Q2s,T1l,T2l,T1h,T2h,Q1l,Q2l,Q1h,Q2h,T1ps,T2ps,count]
            output = open('optimize_data1.pkl', 'wb')
            pickle.dump(data, output)
            output.close()

            time2 = time.time()
            etime = time2-time1

            print
            print
            print 'Count ',count, res.info.status, etime, Z
            print 'Current Values         (T)   %5.2f %5.2f '%(t1,t2)
            print 'Current Prediction           %5.2f %5.2f '%(t1p,t2p)
            print 'Prediction Errors            %5.2f %5.2f '%(pe1,pe2)            
            print 'Current Targets        (Ts)  %5.2f %5.2f '%(t1s,t2s)
            print 'Future Biased Prediction     %5.2f %5.2f '%(t1pss+pe1,t2pss+pe2)
            print 'SS target (optimizer)        %5.2f %5.2f '%(t1ss_tgt,t2ss_tgt)
            print ' - - - -'         
            print 'Heat inputs (current)  (Q)   %5.2f %5.2f '%(q1,q2)
            print 'Heat inputs (steady State)   %5.2f %5.2f '%(q1ss,q2ss)
            print 'SS target (optimizer)        %5.2f %5.2f '%(q1ss_tgt,q2ss_tgt)
                        
            count = count +1

            if count == 240:
                c1 = -0.1
                c2 = -1.0



    except (KeyboardInterrupt, SystemExit):
        print '\nOK - shutting down by keyboard request\n'
        break

# turn heater off
a.Q1(0.0)
a.Q2(0.0)


