import pylab
import numpy
import pickle
import mylib

myfile = open('openloop_data1.pkl')
data = pickle.load(myfile)
myfile.close()

Uc1 = data[0]
Uc2 = data[1]
Y1  = data[2]
Y2  = data[3]

myfile = open('openloop_data2.pkl')
data = pickle.load(myfile)
myfile.close()

a = numpy.array(data)

# extract data from array
t  = (a[:,0] - a[0,0])/60.0
t1 = a[:,1]
t2 = a[:,2]
q1 = a[:,3]
q2 = a[:,4]

t10 = t1[0]
t20 = t2[0]

print Y1.shape
print t1.shape
print t.shape

pylab.rcParams.update(mylib.params)


pylab.subplot(221)
pylab.plot( t, t10+Y1 ,      label = '$T_1$ expected')
pylab.plot( t, t1,                             label = '$T_1$ measured')
pylab.legend()

pylab.subplot(222)
pylab.plot( t, t20+Y2 ,      label = '$T_2$ expected')
pylab.plot( t, t2,                             label = '$T_2$ measured')
pylab.legend()


pylab.subplot(223)
pylab.plot( t,q1, 'g',   label = '$q_1$')
pylab.ylim([0,100])
pylab.legend(loc="lower right")
pylab.xlabel("Time (minutes)")

pylab.subplot(224)
pylab.plot( t,q2 , 'g',  label = '$q_2$')
pylab.ylim([0,100])
pylab.legend(loc="lower right")
pylab.xlabel("Time (minutes)")

pylab.savefig('open_loop.pdf')
pylab.show()

