import sys
import pylab
import numpy
import pickle
import mylib
import tclab

#
# load model file
#
myfile = open('model.pkl')
model = pickle.load(myfile)
myfile.close()
h11 = model['H11']
h12 = model['H12']
h21 = model['H21']
h22 = model['H22']


N = len(h11) - 1
print 'N  ',N

PT = [1,3,7,15,27,51,81]
P = len(PT)
print 'P  ',P



Nc = N+PT[-1]
print 'Nc ',Nc
print


# Tuning
w1 = 1.0
w2 = 1.0
m1 = 1.0
m2 = 1.0

# setpoints
y1s = 20.0
y2s = 20.0


print 'weights      ', w1, w2
print 'move penalty ', m1, m2
print 'setpoints    ',y1s,y2s
print

Y1s = y1s*numpy.ones((Nc,1))
Y2s = y2s*numpy.ones((Nc,1))
Ys = numpy.vstack( (Y1s,Y2s) )
print 'Ys ',Ys.shape

W = numpy.eye(Nc)
W[Nc-1,Nc-1] = 1.0  # weight to get to steady state
Wc = numpy.block([[w1*W, 0*W], [0*W, w2*W]])
print 'Wc ',Wc.shape, W.shape

Q = numpy.eye(Nc)
for i in range(Nc-1):
    Q[i+1,i] = -1.0
Qc = numpy.block([[m1*Q, 0*Q], [0*Q, m2*Q]])
print 'Qc ',Qc.shape, Q.shape

# create M for blocking moves
M = numpy.zeros((Nc,P))
indx = 0
for i in range(P-1):
    for j in range( PT[i],PT[i+1] ):
        M[j-1,i] = 1.0
M[j,P-1] = 1.0
for i in range(Nc-N,Nc):
    M[i,P-1] = 1.0
Mc = numpy.block([[M, 0*M], [0*M, M]])
print 'Mc ',Mc.shape, M.shape


H11 = numpy.zeros((Nc,Nc))
H12 = numpy.zeros((Nc,Nc))
H21 = numpy.zeros((Nc,Nc))
H22 = numpy.zeros((Nc,Nc))
for i in range(Nc):
    for j in range(i+1):
        if i-j < N+1:
            H11[i,j] = h11[i-j]
            H12[i,j] = h12[i-j]
            H21[i,j] = h21[i-j]
            H22[i,j] = h22[i-j]
Hc = numpy.block([[H11, H12], [H21, H22]])
print 'Hc ',Hc.shape

HM = numpy.matmul(Hc,Mc)
print 'HM ',HM.shape

Ac = numpy.matmul(Wc,HM)
print 'Ac ',Ac.shape

Bc = numpy.matmul(Wc,Ys)
print 'Bc ',Bc.shape

QM = numpy.matmul(Qc,Mc)
print 'QM ',QM.shape

A = numpy.vstack( (Ac, -QM) )
print 'A  ',A.shape

B = numpy.vstack( (Bc, 0*Bc) )
print 'B  ',B.shape


Ai = numpy.linalg.inv( numpy.matmul(A.T,A) )
print 'Ai ',Ai.shape
Up = numpy.matmul(A.T, B)
Up = numpy.matmul(Ai,Up)
Up1 = Up[:P]
Up2 = Up[P:]


print 'U  ',Up.shape,Up1.shape,Up2.shape
print
print 'Up1 ',Up1.T
print
print 'Up2 ',Up2.T
print



Uc1 = numpy.matmul(M,Up1)
Uc2 = numpy.matmul(M,Up2)

Y1 = numpy.matmul(H11,Uc1) + numpy.matmul(H12,Uc2)
Y2 = numpy.matmul(H21,Uc1) + numpy.matmul(H22,Uc2)

# append initial zeros for plotting
Uc1 = numpy.append([0],Uc1)
Uc2 = numpy.append([0],Uc2)
Y1  = numpy.append([0],Y1)
Y2  = numpy.append([0],Y2)


print 'Uc1  ',Uc1.shape
print 'Uc2  ',Uc2.shape
print 'Y1   ',Y1.shape
print 'Y2   ',Y2.shape
print 


pylab.rcParams.update(mylib.params)

t = numpy.arange(Nc+1) * 5.0/60.0
print 't   ',t.shape

pylab.subplot(221)
pylab.plot( t, Y1 ,      label = '$T_1$')
pylab.legend()

pylab.subplot(222)
pylab.plot( t, Y2 ,      label = '$T_2$')
pylab.legend()


pylab.subplot(223)
pylab.plot( t,Uc1, 'g',   label = '$q_1$')
pylab.ylim([0,100])
pylab.legend(loc="lower right")
pylab.xlabel("Time (minutes)")

pylab.subplot(224)
pylab.plot( t,Uc2 , 'g',  label = '$q_2$')
pylab.ylim([0,100])
pylab.legend(loc="lower right")
pylab.xlabel("Time (minutes)")

pylab.savefig('open_loop_blocking.pdf')
pylab.show()




