import sys
import pylab
import numpy
import pickle
import mylib
import tclab

#
# load model file
#
myfile = open('model.pkl')
model = pickle.load(myfile)
myfile.close()
h11 = model['H11']
h12 = model['H12']
h21 = model['H21']
h22 = model['H22']


N = len(h11) - 1
print 'N  ',N

P = 100
print 'P  ',P

Nc = N+P+0
print 'Nc ',Nc
print

# Tuning
w1 = 1.0
w2 = 1.0
m1 = 2.1
m2 = 2.1

# setpoints
y1s = 20.0
y2s = 20.0


print 'weights      ', w1, w2
print 'move penalty ', m1, m2
print 'setpoints    ',y1s,y2s
print

Y1s = y1s*numpy.ones((Nc,1))
Y2s = y2s*numpy.ones((Nc,1))
Ys = numpy.vstack( (Y1s,Y2s) )
print 'Ys ',Ys.shape

W = numpy.eye(Nc)
W[Nc-1,Nc-1] = 1.0  # weight to get to steady state
Wc = numpy.block([[w1*W, 0*W], [0*W, w2*W]])
print 'Wc ',Wc.shape, W.shape

Q = numpy.eye(Nc)
for i in range(Nc-1):
    Q[i+1,i] = -1.0
Qc = numpy.block([[m1*Q, 0*Q], [0*Q, m2*Q]])
print 'Qc ',Qc.shape, Q.shape


M = numpy.zeros((Nc,P))
for i in range(P):
    M[i,i] = 1.0
for i in range(P,Nc):
    M[i,P-1] = 1.0
Mc = numpy.block([[M, 0*M], [0*M, M]])
print 'Mc ',Mc.shape, M.shape



H11 = numpy.zeros((Nc,Nc))
H12 = numpy.zeros((Nc,Nc))
H21 = numpy.zeros((Nc,Nc))
H22 = numpy.zeros((Nc,Nc))
for i in range(Nc):
    for j in range(i+1):
        if i-j < N+1:
            H11[i,j] = h11[i-j]
            H12[i,j] = h12[i-j]
            H21[i,j] = h21[i-j]
            H22[i,j] = h22[i-j]
Hc = numpy.block([[H11, H12], [H21, H22]])
print 'Hc ',Hc.shape

HM = numpy.matmul(Hc,Mc)
print 'HM ',HM.shape

Ac = numpy.matmul(Wc,HM)
print 'Ac ',Ac.shape

Bc = numpy.matmul(Wc,Ys)
print 'Bc ',Bc.shape

QM = numpy.matmul(Qc,Mc)
print 'QM ',QM.shape

A = numpy.vstack( (Ac, -QM) )
print 'A  ',A.shape

B = numpy.vstack( (Bc, 0*Bc) )
print 'B  ',B.shape


Ai = numpy.linalg.inv( numpy.matmul(A.T,A) )
print 'Ai ',Ai.shape
Up = numpy.matmul(A.T, B)
Up = numpy.matmul(Ai,Up)
Up1 = Up[:P]
Up2 = Up[P:]


print 'U  ',Up.shape,Up1.shape,Up2.shape
print
print Up1[-4:].T
print
print Up2[-4:].T
print



Uc1 = numpy.matmul(M,Up1)
Uc2 = numpy.matmul(M,Up2)

Y1 = numpy.matmul(H11,Uc1) + numpy.matmul(H12,Uc2)
Y2 = numpy.matmul(H21,Uc1) + numpy.matmul(H22,Uc2)

data = [Uc1, Uc2, Y1, Y2]
output = open('openloop_data1.pkl', 'wb')
pickle.dump(data, output)
output.close()



print y1s,Y1[-3:].T
print
print y2s,Y2[-3:].T
print


sample_time = 5 # seconds

# Connect to Arduino and display messages
a = tclab.TCLab()
print

# start timer that keeps constant sample time
mytimer = mylib.ControlTimer(sample_time)
t_start = float(mytimer.nexttime)

data = []
count = 0
while count < Nc:
    try:
        if mytimer.run():
            t1,t2,q1,q2 = a.scan()                             # get values from tclab board
            print count,t1,t2,q1,q2
            data.append([mytimer.runtime, t1,t2,q1,q2])

            u1 = Uc1[count,0]
            u2 = Uc2[count,0]
            a.Q1(u1) # set heater 1
            a.Q2(u2) # set heater 2
            count = count +1

    except (KeyboardInterrupt, SystemExit):
        print '\nOK - shutting down by keyboard request\n'
        break

print

# set heater OFF
a.Q1(0)
a.Q2(0)
t1,t2,q1,q2 = a.scan()                             # get values from tclab board
print t1,t2,q1,q2
a.close()

print
print len(data)

output = open('openloop_data2.pkl', 'wb')
pickle.dump(data, output)
output.close()


