import sys
import numpy
import pylab
import mylib

print 'One Future Move Example'
h = [ 0.0, 0.7, 0.2, 0.1, 0.0 ]

h = numpy.array(h)
print 'h',h.shape
print h

N = len(h) - 1
print 'N ',N

P = 1
print 'P ',P

Nc = N+P+0
print 'Nc ',Nc

W = numpy.eye(Nc)

#W[Nc-1,Nc-1] = 10000.0  # more weight on last Y getting to target (default is one)

print 'W ',W.shape
print W

M = numpy.zeros((Nc,P))
for i in range(P):
    M[i,i] = 1.0
for i in range(P,Nc):
    M[i,P-1] = 1.0
print 'M ', M.shape
print M



H = numpy.zeros((Nc,Nc))
for i in range(Nc):
    for j in range(i+1):
        if i-j < N+1:
            H[i,j] = h[i-j]
print 'H ',H.shape
print H


HM = numpy.matmul(H,M)
print 'HM ',HM.shape

Yr = numpy.ones((Nc,1))
print 'Yr ',Yr.shape

Bc = numpy.matmul(W,Yr)
print 'Bc ',Bc.shape

Ac = numpy.matmul(W,HM)
print 'Ac ',Ac.shape

print
print 'N,P,Nc ',N,P,Nc

print
print 'Best Guess'
Up = 1.0*numpy.ones((P,1))
print 'Up ',Up

Jc = Bc - numpy.matmul(Ac,Up)
Jc = numpy.matmul(Jc.T,Jc)
print 'Jc ',Jc

Yc = numpy.matmul(HM,Up)
print 'Yc ',Yc.shape
print Yc.T




Ai = numpy.linalg.inv( numpy.matmul(Ac.T,Ac) )

print
print 'Optimal Solutuon '
Up = numpy.matmul(Ac.T, Bc)
Up = numpy.matmul(Ai,Up)
print 'Up',Up


Jc = Bc - numpy.matmul(Ac,Up)
Jc = numpy.matmul(Jc.T,Jc)
print 'Jc ',Jc

HM = numpy.matmul(H,M)
Yc = numpy.matmul(HM,Up)
print 'Yc ',Yc.shape
print Yc.T

Uc = numpy.matmul(M,Up)
print 'Uc ',Uc.shape
print Uc.T

pylab.rcParams.update(mylib.params)

pylab.plot( numpy.append([0],Yc) ,     label = '$Y_c$')
pylab.plot( numpy.append([0],Yr) ,':', label = '$Y_r$')
pylab.legend()

pylab.savefig('one_move.pdf')
pylab.show()

