import time


#
# PYLAB plot settings for all plots
#
fig_width  = 8.0  # width in inches
fig_height = 5.0  # height in inches
fig_size =  [fig_width,fig_height]
params = { 'figure.figsize': fig_size }




class ControlTimer:

    def __init__(self, interval = 5, offset = 0, sleep = 50):
        if offset < 0:
            offset = 0
        if offset > 59:
            offset = 0
        if interval < 1:
            interval = 1
        if offset > interval:
            offset = 0
        if sleep < 50:
            sleep = 50
        if sleep > 2000:
            sleep = 2000

        self.offset   = offset
        self.interval = interval
        self.sleep    = sleep/1000.0

        now = time.time()
        self.starttime = now

        # find next runtime
        newts = []
        nowts = time.localtime(now)
        for i in range(len(nowts)):
            if i != 5:
                newts.append(nowts[i])
            else:
                newts.append(0)
        new = time.mktime(tuple(newts))

        # find next allowable execution time
        i = 0
        while( new + offset + i*interval <= now + 2.0):
            i += 1
        self.nexttime = new + offset + i*interval
        self.runtime  = new + offset


    def run(self):
        now = time.time()
        if now >= self.nexttime:
            self.runtime   = self.nexttime
            self.nexttime += self.interval
            return True
        else:
            time.sleep(self.sleep)
            return False

# end of timer class

