import sys
import pylab
import numpy
import pickle
import mylib

myfile = open('data.pkl')
data = pickle.load(myfile)
myfile.close()



#
# extract data into vectors
#
a = numpy.array(data)
t  = (a[:,0] - a[0,0])/60.0
dt = a[1,0] - a[0,0]
t1 = a[:,1]
t2 = a[:,2]
q1 = a[:,3]
q2 = a[:,4]

print 'Sample Time ',dt
print 'Data Length ',len(t)

#
# differentiate data before identifcation
#
y1 = numpy.diff( t1-t1[0] )
y2 = numpy.diff( t2-t2[0] )
u1 = numpy.diff( q1-q1[0] )
u2 = numpy.diff( q2-q2[0] )


#
# Perform Identification
#

M = len(y1)  # lenght of data

N = 179      # Number of coefficients to estimate = N+1


# Build Regressor
Y1 = y1[N:M]
Y2 = y2[N:M]
U1 = u1[N:M]
U2 = u2[N:M]

for i in range(N):
    uu1 = u1[N-1-i:M-i-1]
    U1  = numpy.column_stack((U1,uu1))
    uu2 = u2[N-1-i:M-i-1]
    U2  = numpy.column_stack((U2,uu2))
print U1.shape, U2.shape, Y1.shape, Y2.shape

U = numpy.column_stack((U1,U2))


#
# Least Squares Estimate
#
X = numpy.matmul(U.T,U)
(r,s) = X.shape

XI = numpy.linalg.inv(X)
XI = numpy.matmul(XI,U.T)

print 'Un-smoothened estimate'

# estimate response to sensor #1
H1  = numpy.matmul(XI,Y1)
H11 = H1[0:N+1]
H12 = H1[N+1:]
print H1.shape, H11.shape, H12.shape, numpy.sum(H11), numpy.sum(H12)


# estimate response to sensor #2
H2  = numpy.matmul(XI,Y2)
H21 = H2[0:N+1]
H22 = H2[N+1:]
print H2.shape,H21.shape, H22.shape, numpy.sum(H21), numpy.sum(H22)




# Matrix to penalize movement between coefficients (i.e. smoothening)
A = numpy.eye(r,s) - numpy.eye(r,s,-1); A[N+1,N] = 0.0

# Matrix to force more smoothening for later coefficients
L = numpy.diag(range(1,N+2)+range(1,N+2))

ALA = numpy.matmul(A.T,L)
ALA = numpy.matmul(ALA,A)

reg = 5000.0

XI = numpy.linalg.inv(X+reg*ALA)
XI = numpy.matmul(XI,U.T)

print 'Un-smoothened estimate'


# estimate response to sensor #1
H1s  = numpy.matmul(XI,Y1)
H11s = H1s[0:N+1]
H12s = H1s[N+1:]
print H1s.shape, H11s.shape, H12s.shape


# estimate response to sensor #2
H2s  = numpy.matmul(XI,Y2)
H21s = H2s[0:N+1]
H22s = H2s[N+1:]
print H2s.shape,H21s.shape, H22s.shape

#
# Save model to file
#
model = {}
model['H1']  = H1s
model['H11'] = H11s
model['H12'] = H12s
model['H2']  = H2s
model['H21'] = H21s
model['H22'] = H22s
model_file = open( "model.pkl", "wb" )
pickle.dump( model , model_file  )
model_file.close()

#
# Calculate Step Responses from impulse responses
#

# un-smoothed estimate
S11 = numpy.zeros(N+1); S12 = numpy.zeros(N+1)
S21 = numpy.zeros(N+1); S22 = numpy.zeros(N+1)
S11[0]  = H11[0]; S12[0]  = H12[0]
S21[0]  = H21[0]; S22[0]  = H22[0]

# smoothed estimate
S11s = numpy.zeros(N+1); S12s = numpy.zeros(N+1)
S21s = numpy.zeros(N+1); S22s = numpy.zeros(N+1)
S11s[0] = H11s[0]; S12s[0] = H12s[0]
S21s[0] = H21s[0]; S22s[0] = H22s[0]

# convert impulse response to step response
for i in range(1,N+1):
    S11[i] = S11[i-1] + H11[i]
    S12[i] = S12[i-1] + H12[i]
    S21[i] = S21[i-1] + H21[i]
    S22[i] = S22[i-1] + H22[i]

    S11s[i] = S11s[i-1] + H11s[i]
    S12s[i] = S12s[i-1] + H12s[i]
    S21s[i] = S21s[i-1] + H21s[i]
    S22s[i] = S22s[i-1] + H22s[i]

# Model Gains
g11 = S11s[N]
g12 = S12s[N]
g21 = S21s[N]
g22 = S22s[N]

print
print 'Model Gains'
print g11, g12
print g21, g22
print







#
# Plot Impulse/Step Resonses and prediction
#

time = numpy.arange(0,N+1)*dt/60.0   # time for plot

xp = 8; yp = 0.4; yp2 = 0.32   # text position



pylab.rcParams.update(mylib.params)



pylab.figure() # impulse response plot

pylab.title('Impulse Response')
pylab.plot(time,H11)   # un-smoothed estimate
pylab.plot(time,H11s)  # smoothed estimate
pylab.xlim([0,15])
pylab.text(xp,0.01, '$T_1$ / $Q_1$ ')
pylab.xlabel('Time (min)')
pylab.savefig('model_id1.pdf')



pylab.figure() # step response plot

pylab.subplot(221)
pylab.plot(time,S11)   # un-smoothed estimate
pylab.plot(time,S11s)  # smoothed estimate
pylab.ylim([0,0.6])
pylab.xlim([0,15])
pylab.text(xp,yp, '$T_1$ / $Q_1$ ')
gain = 'Gain %7.4f'%(g11)
pylab.text(xp,yp2, gain)


pylab.subplot(222)
pylab.plot(time,S12)   # un-smoothed estimate
pylab.plot(time,S12s)  # smoothed estimate
pylab.ylim([0,0.6])
pylab.xlim([0,15])
pylab.text(xp,yp, '$T_1$ / $Q_2$ ')
gain = 'Gain %7.4f'%(g12)
pylab.text(xp,yp2, gain)

pylab.subplot(223)
pylab.plot(time,S21)   # un-smoothed estimate
pylab.plot(time,S21s)  # smoothed estimate
pylab.ylim([0,0.6])
pylab.xlim([0,15])
pylab.xlabel('Time (min)')
pylab.text(xp,yp, '$T_2$ / $Q_1$ ')
gain = 'Gain %7.4f'%(g21)
pylab.text(xp,yp2, gain)

pylab.subplot(224)
pylab.plot(time,S22)   # un-smoothed estimate
pylab.plot(time,S22s)  # smoothed estimate
pylab.ylim([0,0.6])
pylab.xlim([0,15])
pylab.xlabel('Time (min)')
pylab.text(xp,yp, '$T_2$ / $Q_2$ ')
gain = 'Gain %7.4f'%(g22)
pylab.text(xp,yp2, gain)

pylab.savefig('model_id2.pdf')
pylab.show()


