import sys
import numpy
import pylab
import mylib

print 'Four Future Moves Example'
h = [ 0.0, 0.7, 0.2, 0.1, 0.0 ]

h = numpy.array(h)
print 'h',h.shape
print h

N = len(h) - 1
print 'N ',N

P = 4
print 'P ',P

Nc = N+P+0
print 'Nc ',Nc


w = 1.0
W = w*numpy.eye(Nc)
W[Nc-1,Nc-1] = 1*w  # more weight on last Y getting to target (default is one)

print 'W ',W.shape
print W

M = numpy.zeros((Nc,P))
for i in range(P):
    M[i,i] = 1.0
for i in range(P,Nc):
    M[i,P-1] = 1.0
print 'M ', M.shape
print M



H = numpy.zeros((Nc,Nc))
for i in range(Nc):
    for j in range(i+1):
        if i-j < N+1:
            H[i,j] = h[i-j]
print 'H ',H.shape
print H


HM = numpy.matmul(H,M)
print 'HM ',HM.shape

Yr = numpy.ones((Nc,1))
print 'Yr ',Yr.shape

Bc = numpy.matmul(W,Yr)
print 'Bc ',Bc.shape

Ac = numpy.matmul(W,HM)
print 'Ac ',Ac.shape

print
print 'N,P,Nc ',N,P,Nc




m = 0.2
Q = numpy.eye(Nc)
for i in range(Nc-1):
    Q[i+1,i] = -1.0
QM = m * numpy.matmul(Q,M)
print QM

A = numpy.vstack( (Ac, -QM) )
O = 0* Bc
B = numpy.vstack( (Bc, O) )
Ai = numpy.linalg.inv( numpy.matmul(A.T,A) )


print
print 'Optimal Solutuon 1, m = ',m 
Up1 = numpy.matmul(A.T, B)
Up1 = numpy.matmul(Ai,Up1)
Jc  = B - numpy.matmul(A,Up1)
Jc1 = numpy.matmul(Jc.T,Jc)
print 'Up1',Up1.T
print 'Jc1 ',Jc1



m = 1.0
Q = numpy.eye(Nc)
for i in range(Nc-1):
    Q[i+1,i] = -1.0
QM = -m * numpy.matmul(Q,M)

A = numpy.vstack( (Ac, QM) )
O = 0* Bc
B = numpy.vstack( (Bc, O) )
Ai = numpy.linalg.inv( numpy.matmul(A.T,A) )

print
print 'Optimal Solutuon 2, m = ',m 
Up2 = numpy.matmul(A.T, B)
Up2 = numpy.matmul(Ai,Up2)
Jc  = B - numpy.matmul(A,Up2)
Jc2 = numpy.matmul(Jc.T,Jc)
print 'Up2',Up2.T
print 'Jc2 ',Jc2


Yc1 = numpy.matmul(HM,Up1)
Yc2 = numpy.matmul(HM,Up2)
Uc1 = numpy.matmul(M,Up1)
Uc2 = numpy.matmul(M,Up2)

pylab.rcParams.update(mylib.params)


pylab.subplot(211)
pylab.plot( numpy.append([0],Yc1) ,      label = '$Y$ - solution #1')
pylab.plot( numpy.append([0],Yc2) ,      label = '$Y$ - solution #2')
pylab.legend()

pylab.subplot(212)
pylab.plot( numpy.append([0],Uc1) ,      label = '$U$ - solution #1')
pylab.plot( numpy.append([0],Uc2) ,      label = '$U$ - solution #2')
pylab.legend()

pylab.savefig('four_moves.pdf')
pylab.show()

