import pylab
import numpy
import scipy
import osqp
import pickle
import mylib

myfile = open('data.pkl')
data = pickle.load(myfile)
myfile.close()

a = numpy.array(data)


# extract data from array
t  = (a[:,0] - a[0,0])/60.0
t1 = a[:,1]
t2 = a[:,2]
q1 = a[:,3]
q2 = a[:,4]


# initial temperatures
t10 = 19; t20 = 19;

# gain matrix
A = numpy.array([ [0.5930 , 0.0967],[0.2546 , 0.2869]])
B = numpy.array([[t10]*5,[t20]*5])

# heat inputs
U = numpy.array([ [ 0  ,100 , 100, 0 , 0], [0 , 0, 100, 100, 0]]) 

# expected temperatures
Y = numpy.matmul(A,U)+B

# temperature constraints
tl1 = 30; tl2 = 30; th1 = 60; th2 = 50
Z1 = numpy.array([ [ tl1  , th1 , th1, tl1 , tl1], [ tl2 , tl2, th2, th2, tl2]]) 

# heat constraints
ql1 = 10; ql2 = 20; qh1 = 90; qh2 = 80
U = numpy.array([ [ ql1  ,qh1 , qh1, ql1 , ql1], [ql2 , ql2, qh2, qh2, ql2]]) 
Z2 = numpy.matmul(A,U)+B


# solve QP
P = scipy.sparse.csc_matrix([[0, 0], [0, 0]])
q = numpy.array([-0.1, -1.0])
AA = scipy.sparse.csc_matrix([[0.5930 , 0.0967],[0.2546 , 0.2869],[1,0],[0,1]])
l = numpy.array([tl1-t10,tl2-t20,ql1,ql2])
u = numpy.array([th1-t10,th2-t20,qh1,qh2])

prob = osqp.OSQP()
prob.setup(P, q, AA, l, u, alpha=1.0, polish=True, verbose=True)
res = prob.solve()


print res.x
Z3 = numpy.matmul(A,res.x)+numpy.array([[t10,t20]])
print Z3


fig_width  = 6.0  # width in inches
fig_height = 8.0  # height in inches
fig_size =  [fig_width,fig_height]
params = { 'figure.figsize': fig_size }
pylab.rcParams.update(params)



pylab.title('Operating envelope')
pylab.scatter(t1,t2,marker='.',color='gold')
pylab.plot(Y[0,:],Y[1,:], color='r')
pylab.plot(Z1[0,:],Z1[1,:], color='g')
pylab.plot(Z2[0,:],Z2[1,:], color='b')
pylab.plot(Z3[0,0],Z3[0,1],'o',color='m', ms=10)
pylab.xlabel("$T_1$")
pylab.ylabel("$T_2$")
pylab.ylim([10,90])
pylab.xlim([10,90])

pylab.savefig('envelope.pdf')
pylab.show()

