import sys
import time
import pylab
import numpy
import pickle
import mylib



#
# load model file
#
myfile = open('model.pkl')
model = pickle.load(myfile)
myfile.close()
h11 = model['H11']

N = len(h11) - 1
print 'N  ',N


#
# Load data
#
myfile = open('control_data2.pkl')
data1 = pickle.load(myfile)
data2 = pickle.load(myfile)
myfile.close()




T1  = data1[0]
T1s = data1[1]
T1p = data1[2]
T2  = data1[3]
T2s = data1[4]
T2p = data1[5]
Q1  = data1[6]
Q1s = data1[7]
Q2  = data1[8]
Q2s = data1[9]
cnt = data1[10]

print 'count ', cnt


#data2 = [t1f, t2f, t1_sp, t2_sp, Up1, Up2 ]
t1f   = data2[0]
t2f   = data2[1]
t1_sp = data2[2]
t2_sp = data2[3]
Up1   = data2[4]
Up2   = data2[5]


times1 = numpy.arange(cnt)*5.0/60.0
times2 = (numpy.arange( len(t1f) )+cnt)*5.0/60.0
times3 = (numpy.arange( len(Up1) )+cnt)*5.0/60.0

# future set-point for plotting
t1s   = numpy.zeros( len(t1f) ) + +T1s[N+cnt-1]  
t2s   = numpy.zeros( len(t1f) ) + +T2s[N+cnt-1] 


# plot data
pylab.rcParams.update(mylib.params)

xlimit = [0,30]
pylab.figure()

pylab.subplot(221)
pylab.plot(times1,T1p[N:N+cnt],  label = '$T_1$ prediction' )
pylab.plot(times2,t1f)
pylab.plot(times1,T1s[N:N+cnt])
pylab.plot(times2,t1s,'--',color='g')
pylab.xlim(xlimit)
pylab.legend()

pylab.subplot(222)
pylab.plot(times1,T2p[N:N+cnt],  label = '$T_2$ prediction' )
pylab.plot(times2,t2f)
pylab.plot(times1,T2s[N:N+cnt])
pylab.plot(times2,t2s,'--',color='g')
pylab.xlim(xlimit)
pylab.legend()

pylab.subplot(223)
pylab.plot( times1, Q1[N:N+cnt],  label = '$Q_1$'  )
pylab.plot( times3, Up1+Q1[N+cnt-1] )
pylab.xlim(xlimit)
pylab.xlabel("Minutes")
pylab.legend()

pylab.subplot(224)
pylab.plot( times1, Q2[N:N+cnt],  label = '$Q_2$'  )
pylab.plot( times3, Up2+Q2[N+cnt-1] )
pylab.xlim(xlimit)
pylab.xlabel("Minutes")
pylab.legend()

pylab.savefig('control_prediction.pdf')

pylab.show()


