import sys
import time
import pylab
import numpy
import pickle
import mylib



#
# load model file
#
myfile = open('model.pkl')
model = pickle.load(myfile)
myfile.close()
h11 = model['H11']

N = len(h11) - 1
print 'N  ',N


#
# Load data
#
myfile = open('control_data1.pkl')
data = pickle.load(myfile)
myfile.close()


T1  = data[0]
T1s = data[1]
T1p = data[2]
T2  = data[3]
T2s = data[4]
T2p = data[5]
Q1  = data[6]
Q1s = data[7]
Q2  = data[8]
Q2s = data[9]

L = len(T1) - N
times1 = numpy.arange(L)*5.0/60.0


# plot data
pylab.rcParams.update(mylib.params)

pylab.figure()

pylab.subplot(221)
pylab.plot( times1,  T1[N:] ,  label = '$T_1$'   )
pylab.plot( times1, T1s[N:] ,  label = 'tgt' )
pylab.plot( times1, T1p[N:] ,  label = 'pred' )
pylab.legend()

pylab.subplot(222)
pylab.plot( times1,  T2[N:] ,  label = '$T_2$'   )
pylab.plot( times1, T2s[N:] ,  label = 'tgt' )
pylab.plot( times1, T2p[N:] ,  label = 'pred' )
pylab.legend()

pylab.subplot(223)
pylab.plot( times1, Q1[N:] ,  label = '$q_1$' )
pylab.plot( times1, Q1s[N:] , label = 'tgt' )
pylab.ylim([0,100])
pylab.legend()
pylab.xlabel("Minutes")

pylab.subplot(224)
pylab.plot( times1, Q2[N:] ,  label = '$q_2$' )
pylab.plot( times1, Q2s[N:] , label = 'tgt' )
pylab.ylim([0,100])
pylab.legend()
pylab.xlabel("Minutes")

pylab.savefig('control.pdf')

pylab.show()


