import sys
import time
import pylab
import numpy
import pickle
import mylib
import tclab

# Connect to Arduino and display messages
print
a = tclab.TCLab()

# get initial values from device
t10,t20,q10,q20 = a.scan() 

print

#
# load model file
#
myfile = open('model.pkl')
model = pickle.load(myfile)
myfile.close()
h11 = model['H11']
h12 = model['H12']
h21 = model['H21']
h22 = model['H22']


N = len(h11) - 1
print 'N  ',N

P = 100
print 'P  ',P

Nc = N+P
print 'Nc ',Nc
print

# Tuning
w1 = 0.5
w2 = 0.5
m1 = 4.0
m2 = 4.0

# setpoints
t1s = 20.0
t2s = 20.0

# run length
R = 400

# Control ON/OFF
control = True


# initial heater values
u10 = 0.0
u20 = 0.0

# set initial heater values
a.Q1(u10)
a.Q2(u20)


print 'weights      ', w1, w2
print 'move penalty ', m1, m2
print 'setpoints    ', t1s,t2s
print 'initial htr  ', u10, u20
print 'Run length   ', R
print



# arrays for holding data
T1s  = numpy.array( ([t1s]*(N) + [numpy.NaN]*R) )  # setpoint
T2s  = numpy.array( ([t2s]*(N) + [numpy.NaN]*R) )  # setpoint
T1p  = numpy.array( ([t10]*(N) + [numpy.NaN]*R) )  # prediction
T2p  = numpy.array( ([t20]*(N) + [numpy.NaN]*R) )  # prediction
T1ps = numpy.array( ([t10]*(N) + [numpy.NaN]*R) )  # ss-prediction no control
T2ps = numpy.array( ([t20]*(N) + [numpy.NaN]*R) )  # ss-prediction no control
T1   = numpy.array( ([t10]*(N) + [numpy.NaN]*R) )  # temperature
T2   = numpy.array( ([t20]*(N) + [numpy.NaN]*R) )  # temperature
Q1   = numpy.array( ([q10]*(N) + [numpy.NaN]*R) )  # heater
Q2   = numpy.array( ([q20]*(N) + [numpy.NaN]*R) )  # heater
Q1s  = numpy.array( ([q10]*(N) + [numpy.NaN]*R) )  # heater - tgt
Q2s  = numpy.array( ([q20]*(N) + [numpy.NaN]*R) )  # heater - tgt
PE1  = numpy.array( ([0.0]*(N) + [numpy.NaN]*R) )  # prediction error
PE2  = numpy.array( ([0.0]*(N) + [numpy.NaN]*R) )  # prediction error


# matrices for future prediction
H11p = numpy.zeros( (Nc,Nc+N) )
H12p = numpy.zeros( (Nc,Nc+N) )
H21p = numpy.zeros( (Nc,Nc+N) )
H22p = numpy.zeros( (Nc,Nc+N) )

for i in range(Nc):
    for j in range(N+1):
        H11p[i,i+j] = h11[N-j]
        H12p[i,i+j] = h12[N-j]
        H21p[i,i+j] = h21[N-j]
        H22p[i,i+j] = h22[N-j]


# matrices for control
W = numpy.eye(Nc)
W[Nc-1,Nc-1] = 100.0  # weight to get to steady state
Wc = numpy.block([[w1*W, 0*W], [0*W, w2*W]])

Q = numpy.eye(Nc)
for i in range(Nc-1):
    Q[i+1,i] = -1.0
Qc = numpy.block([[m1*Q, 0*Q], [0*Q, m2*Q]])

M = numpy.zeros((Nc,P))
for i in range(P):
    M[i,i] = 1.0
for i in range(P,Nc):
    M[i,P-1] = 1.0
Mc = numpy.block([[M, 0*M], [0*M, M]])

H11 = numpy.zeros((Nc,Nc))
H12 = numpy.zeros((Nc,Nc))
H21 = numpy.zeros((Nc,Nc))
H22 = numpy.zeros((Nc,Nc))
for i in range(Nc):
    for j in range(i+1):
        if i-j < N+1:
            H11[i,j] = h11[i-j]
            H12[i,j] = h12[i-j]
            H21[i,j] = h21[i-j]
            H22[i,j] = h22[i-j]
Hc = numpy.block([[H11, H12], [H21, H22]])

HM = numpy.matmul(Hc,Mc)
Ac = numpy.matmul(Wc,HM)
QM = numpy.matmul(Qc,Mc)
A  = numpy.vstack( (Ac, -QM) )
Ai = numpy.linalg.inv( numpy.matmul(A.T,A) )






print

# start timer that keeps constant sample time
count       = 0
sample_time = 5 # seconds
mytimer     = mylib.ControlTimer(sample_time)
t_start     = float(mytimer.nexttime)


while count < R:
    try:
        if mytimer.run():

            time1 = time.time()        
            # get values from device
            t1,t2,q1,q2 = a.scan() 

            
            # store values for plotting
            T1s[N+count] = t1s
            T2s[N+count] = t2s
            T1[N+count]  = t1
            T2[N+count]  = t2
            Q1[N+count]  = q1
            Q2[N+count]  = q2
            
            
            # calculate predicted temperatures at current time
            u1 = Q1[count:N+count+1]-q10
            u2 = Q2[count:N+count+1]-q20 
            a11 = numpy.dot( numpy.flip(h11) ,  u1 )
            a12 = numpy.dot( numpy.flip(h12) ,  u2 )
            a21 = numpy.dot( numpy.flip(h21) ,  u1 )
            a22 = numpy.dot( numpy.flip(h22) ,  u2 )
            t1p = t10 + a11 + a12
            t2p = t20 + a21 + a22
            
            # calculate prediction error
            pe1 = t1 - t1p
            pe2 = t2 - t2p

            # store values for plotting
            T1p[N+count]  = t1p
            T2p[N+count]  = t2p            
            PE1[N+count]  = pe1
            PE2[N+count]  = pe2            
           
            
            # calculate future prediction vectors with no control
            u1p = numpy.zeros((Nc)) + q1 - q10
            u2p = numpy.zeros((Nc)) + q2 - q20
            U1P = numpy.concatenate((u1[1:],u1p))
            U2P = numpy.concatenate((u2[1:],u2p))
            t1f = numpy.matmul(H11p,U1P) + numpy.matmul(H12p,U2P) + t10  # vector
            t2f = numpy.matmul(H21p,U1P) + numpy.matmul(H22p,U2P) + t20  # vector
            
            # steady state prediction - unbiased - no control
            t1pss = t1f[-1]
            t2pss = t2f[-1]

            # store values for plotting
            T1ps[N+count] = t1pss 
            T2ps[N+count] = t2pss

 
            # future setpoints vectors
            t1_sp = numpy.array( ( [t1s]*Nc)) - t1f  - pe1
            t2_sp = numpy.array( ( [t2s]*Nc)) - t2f  - pe2
 
            # calculate moves
            Ys = numpy.concatenate( (t1_sp,t2_sp) )
            Bc = numpy.matmul(Wc,Ys)
            B = numpy.concatenate( (Bc, 0*Bc) ) 
            
            # move plan
            Up = numpy.matmul(A.T, B)
            Up = numpy.matmul(Ai,Up)
            Up1 = Up[:P]
            Up2 = Up[P:]
            move1 = Up1[0]
            move2 = Up2[0]
            q1ss  = Up1[-1] + q1
            q2ss  = Up2[-1] + q2            


            # store values for plotting
            Q1s[N+count]  = q1ss
            Q2s[N+count]  = q2ss           


            #implement moves and limit to range 0-100
            if control:
                u1 = min( max(q1 + move1,0) , 100)
                u2 = min( max(q2 + move2,0) , 100)
                a.Q1(u1)
                a.Q2(u2)

            # save data
            data = [T1,T1s,T1p,T2,T2s,T2p,Q1,Q1s,Q2,Q2s]
            output = open('control_data1.pkl', 'wb')
            pickle.dump(data, output)
            output.close()

            time2 = time.time()
            etime = time2-time1
            
            print '%4d - Q1 %4.1f  - Q2 %4.1f  - T1 %5.1f  - T2 %5.1f   - etime %5.2f - sp %4.1f %4.1f'%(count, q1,q2,t1,t2,etime,t1s,t2s )
            count = count +1


            # target changes
            if count == 10:
                t1s = 55.0
                t2s = 45.0

            if count == 160:
                t1s = 45.0
                t2s = 50.0

            # saved future predictions
            if count == 50:
                output = open('control_data2.pkl', 'wb')
                data1 = [T1,T1s,T1p,T2,T2s,T2p,Q1,Q1s,Q2,Q2s,count]
                pickle.dump(data1, output)
                data2 = [t1f, t2f, t1_sp, t2_sp, Up1, Up2 ]
                pickle.dump(data2, output)
                output.close()
                print 'saved'




    except (KeyboardInterrupt, SystemExit):
        print '\nOK - shutting down by keyboard request\n'
        break

# turn heater off
a.Q1(0.0)
a.Q2(0.0)


# plot data
pylab.rcParams.update(mylib.params)

pylab.subplot(221)
pylab.plot(   T1[N:] ,  label = '$T_1$'   )
pylab.plot(  T1s[N:] ,  label = 'tgt' )
pylab.plot(  T1p[N:] ,  label = 'pred' )
#pylab.plot( T1ps[N:] ,  label = '$T_1^{PS}$' )
pylab.legend()

pylab.subplot(222)
pylab.plot(   T2[N:] ,  label = '$T_2$'   )
pylab.plot(  T2s[N:] ,  label = 'tgt' )
pylab.plot(  T2p[N:] ,  label = 'pred' )
#pylab.plot( T2ps[N:] ,  label = '$T_2^{PS}$' )
pylab.legend()

pylab.subplot(223)
pylab.plot( Q1[N:] ,  label = '$q_1$' )
pylab.plot( Q1s[N:] , label = 'tgt' )
pylab.ylim([0,100])
pylab.legend()
pylab.xlabel("Samples")

pylab.subplot(224)
pylab.plot( Q2[N:] ,  label = '$q_2$' )
pylab.plot( Q2s[N:] , label = 'tgt' )
pylab.ylim([0,100])
pylab.legend()
pylab.xlabel("Samples")

pylab.show()


