function [] = mySim(k0)

% Predicted values
[t,x] = ode15s(@(t,x)myModel(t,x,k0),[0 20],3);

% Actual values
k = 0.08;
noise = myNoise();
for i = 1:21,
    time(i) = i-1;
    y(i) = exp(-k*time(i))*3.0 + noise(i);
end

figure(1)
hold off
plot(t,x)
hold on;
plot(time,y,'ro')
xlabel('Time')
ylabel('Value')
legend('Predicted','Actual')
text(1,1,['Predicted k = ' num2str(k0)])
text(1,1.2,['Actual k = ' num2str(k)])