function obj = myObj(k)

% predicted values
n = 30;
time = linspace(0,20,n);
x0 = 3.0;
[t,x] = ode15s(@(t,x)myModel(t,x,k),time,x0);

% measured values
noise = myNoise();
for i = 1:n,
    y(i,1) = exp(-0.08*time(i))*3.0 + noise(i);
end

% compute sum of squared errors
obj = sum((x-y).^2);
