clear all; close all; clc

%% solve graphically
n = 100;
k = linspace(0.05,0.1,n);
for i = 1:n,
    obj(i) = myObj(k(i));
end
figure(1)
plot(k,obj,'b--','LineWidth',3);
xlabel('k value')
ylabel('Objective Value')

%% confidence interval
% (S(k) - S(k*)) / S(k*) <= p / (n-p) * F(p,n-p,1-alpha)
p = 1; % number of parameters
np = 30; % number of data points
alpha = 0.05; % alpha, confidence interval
rhs = p / (np-p) * finv(1-alpha,p,(np-p));
ub = min(obj) * rhs + min(obj);
hold on
plot([min(k) max(k)],[ub ub],'r-','LineWidth',3);
legend('Objective','Confidence Limit')
axis([0.06 0.09 0 1])
axis([0.07 0.09 0 1])
