# solve with APMonitor
from apm import * # download from APMonitor.com
# select the server
s = 'http://xps.apmonitor.com'
# names the application
a = 'parameter_estimation'
# clear any prior applications
apm(s,a,'clear all')
# load model file
apm_load(s,a,'myModel.apm')
# solve the optimization problem
apm(s,a,'solve')
# open a web-viewer
apm_web(s,a)

# Plot results
import matplotlib.pyplot as plt

# retrieve solution
(sol,ans) = apm_sol(s,a)

# plot results
plt.figure()
plt.plot(ans['time'],ans['x'],'b--')
plt.plot(ans['time'],ans['y'],'ro')
plt.legend(['Predicted','Actual'])
plt.xlabel('Time')
plt.ylabel('Values')
plt.show()
