clear all; close all; clc

%% solve with APMonitor
addpath('apm') % download from APMonitor.com
% select the server
s = 'http://xps.apmonitor.com';
% names the application
a = 'parameter_estimation';
% clear any prior applications
apm(s,a,'clear all');
% load model file
apm_load(s,a,'myModel.apm');
% solve the optimization problem
apm(s,a,'solve')
% open a web-viewer
apm_web(s,a);
% retrieve the results into MATLAB
y = apm_sol(s,a); z = y.x;
% display the results
disp(['APMonitor: k = ' num2str(z.k(1))]);
figure(2)
plot(z.time,z.x,'b--')
hold on
plot(z.time,z.y,'ro')
xlabel('Time')
ylabel('Values')
legend('Predicted','Actual')
text(1,1.4,'APMonitor Results')
text(1,1,['Predicted k = ' num2str(z.k(1))])
text(1,1.2,['Actual k = 0.08'])
