

# Solve a parallel pipe network of three pipes.
# Key equations: pressure drop (Dp) is the same in each pipe
# --> Dp_1 = Dp_2, Dp_1 = Dp_3.
# Also include Colbrook equations and flow rates through each pipe
# --> 6 equations in 6 unknowns: 3 friction factors, and 3 flow rates

from scipy.optimize import *
from numpy          import *

#--------------------------------------

def solverF(x) :

    f1 = x[0];
    f2 = x[1];
    f3 = x[2];
    Q1 = x[3];
    Q2 = x[4];
    Q3 = x[5];

    Qt = 0.01333;       # Given total volumetric flow rate
    e1 = 0.00024;       # pipe roughness (m)
    e2 = 0.00012;       
    e3 = 0.0002;
    L1 = 100;           # pipe length (m)
    L2 = 150;
    L3 = 80;
    D1 = 0.05;          # pipe diameter (m)
    D2 = 0.045;
    D3 = 0.04;
    mu = 1.002E-3;      # viscosity (kg/m*s)
    rho = 998;          # density (kg/m3)

    F = zeros((6));

    F[0] = f1*L1/D1*rho/2*(4*Q1/pi/D1**2)**2 - \
           f2*L2/D2*rho/2*(4*Q2/pi/D2**2)**2;     # DP_1 - DP_2 = 0
    F[1] = f1*L1/D1*rho/2*(4*Q1/pi/D1**2)**2 - \
           f3*L3/D3*rho/2*(4*Q3/pi/D3**2)**2;     # DP_1 - DP_3 = 0
    F[2] = 1/sqrt(f1)+2*log10(e1/D1/3.7 + \
           2.51/(rho*D1/mu*4*Q1/pi/D1**2/sqrt(f1)));  # Colbrook 1
    F[3] = 1/sqrt(f2)+2*log10(e2/D2/3.7 + \
           2.51/(rho*D2/mu*4*Q2/pi/D2**2/sqrt(f2)));  # Colbrook 2
    F[4] = 1/sqrt(f3)+2*log10(e3/D3/3.7 + \
           2.51/(rho*D3/mu*4*Q3/pi/D3**2/sqrt(f3)));  # Colbrook 3
    F[5] = Q1+Q2+Q3-Qt;                               # total flow
        
    return F

#--------------------------------------

Qt     = 0.01333;       # Given total volumetric flow rate
xGuess = array([0.01, 0.01, 0.01, 0.004, 0.004, Qt-0.004-0.004]); 
                # f1, f2, f3, Q1, Q2, Q3

x      = fsolve(solverF, xGuess)

print "[f1, f2, f3, Q1, Q2, Q3] = ", x







