from numpy             import *
from scipy.integrate   import *
from matplotlib.pyplot import *

def odeF(y,t) :
    dydt = zeros(2)
    dydt[0] = y[1]
    dydt[1] = 1000*(1-y[0]**2)*y[1]-y[0]
    return dydt

t = linspace(0,3000,500)
y0 = array([2, 0])
y = odeint(odeF, y0, t, mxstep=1000)

plot(t,y[:,0],'-')
ion(); show()


