
from numpy             import *
from scipy.interpolate import *
from matplotlib.pyplot import *

x1        = linspace(0,10,10)
y1        = cos(x1**2/8)
x2        = linspace(0,10,100)

f_linear  = interp1d(x1,y1)
f_spline  = interp1d(x1,y1, kind='cubic')
y2_linear = f_linear(x2)
y2_spline = f_spline(x2)

plot(x1,y1,'o', x2,y2_linear,'-', x2,y2_spline,'--')
legend(['data', 'linear', 'spline'], loc='best')
ion(); show()
