clear all; close all; clc
x = [0,1,2,3,4,5]
y = [0,0.8,0.9,0.1,-0.8,-1];
p1 = polyfit(x,y,1);
p2 = polyfit(x,y,2);
p3 = polyfit(x,y,3);
plot(x,y,'o')
hold on
plot(x,polyval(p1,x),'r-')
xp = linspace(-2,6,100);
plot(xp,polyval(p2,xp),'m--')
plot(xp,polyval(p3,xp),'g:')
plot(xp,polyval(p3,xp),'g:','LineWidth',3)
ylim([-2,2])
xlim([0,5])

yfit = p1(1) * x + p1(2);
yresid = y - yfit;
SSresid = sum(yresid.^2);
SStotal = (length(y)-1) * var(y);
rsq = 1 - SSresid/SStotal;
disp(rsq)
